/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.cache;

import com.google.gson.Gson;
import java.io.File;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

/**
 * the first level is a partial key i.e. a key that may have conflicts
 * the second level is a map with a real key and content
 * 
 * the cache implementation allows only text contents
 * @author lendle
 */
@SuppressWarnings("all")
public class TwoLevelFileCache {
    private File cacheRoot=null;

    public TwoLevelFileCache(File cacheRoot) {
        this.cacheRoot=cacheRoot;
    }
    
    
    /**
     * 
     * @param identifier the original identifier of the content to be cached, will be encoded to be saved to file system
     * @return
     * @throws Exception 
     */
    public String getFromCache(String identifier) throws Exception{
        String partialKey=this.encode2PartialKey(identifier);
        
        File contentFolder=new File(cacheRoot, partialKey);
        if(!contentFolder.exists()){
            return null;
        }
        File contentMapFile=new File(contentFolder, ".index");
        if(!contentMapFile.exists()){
            return null;
        }
        String json=FileUtils.readFileToString(contentMapFile, "utf-8");
        Gson gson=new Gson();
        Map<String, String> contentMap=gson.fromJson(json, Map.class);
        return contentMap.get(this.encode2RealKey(identifier));
    }
    /**
     * 
     * @param identifier the original identifier of the content to be cached, will be encoded to be saved to file system
     * @param content
     * @throws Exception 
     */
    public synchronized void save2Cache(String identifier, String content) throws Exception{
        String partialKey=this.encode2PartialKey(identifier);
        
        File contentFolder=new File(cacheRoot, partialKey);
        if(!contentFolder.exists()){
            contentFolder.mkdirs();
        }
        File contentMapFile=new File(contentFolder, ".index");
        Map<String, String> contentMap=null;
        Gson gson=new Gson();
        if(!contentMapFile.exists()){
            contentMap=new HashMap<>();
        }else{
            String json=FileUtils.readFileToString(contentMapFile, "utf-8");
            contentMap=gson.fromJson(json, Map.class);
        }
        contentMap.put(this.encode2RealKey(identifier), content);
        FileUtils.write(contentMapFile, gson.toJson(contentMap), "utf-8");
    }
    /**
     * a partial key allows duplication to be resolved later
     * @param identifier
     * @return
     * @throws Exception 
     */
    public String encode2PartialKey(String identifier) throws Exception{
        String reverse=new StringBuilder(identifier).reverse().toString();
        String base64 = Base64.getEncoder().encodeToString(identifier.getBytes());
        String base642= Base64.getEncoder().encodeToString(reverse.getBytes());
        String key1 = (base64.length() > 50) ? base64.substring(0, 50) : base64;
        String key2 = (base642.length() > 50) ? base642.substring(0, 50) : base642;
        return (key1+key2).replaceAll("\\W", "_");
    }
    
    public String encode2RealKey(String identifier) throws Exception{
        return identifier;
    }
}
