/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 *
 * @author lendle
 */
public class FilebasedAccessTokenProvider implements AccessTokenProvider {

    private File file = null;

    public FilebasedAccessTokenProvider(File file) {
        this.file = file;
    }

    @Override
    public AccessToken getAccessToken() {
        try (InputStream input = new FileInputStream(file)) {
            GoogleCredentials credentials = GoogleCredentials.fromStream(input);
            credentials = credentials.createScoped("https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/generative-language.retriever");
            credentials.refreshIfExpired();
            AccessToken token = credentials.getAccessToken();
            return token;
        } catch (Exception ex) {
            return null;
        }
    }

}
