/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.gemini;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.Conversation;

/**
 *
 * @author lendle
 */
@SuppressWarnings("all")
public class InlinePassages implements FactSource {
    
    protected List<String> passages = new ArrayList<>();
    /**
     * the static summary content, only valid when
     * staticSummary=true
     */
    protected String staticSummaryContent=null;
    /**
     * if staticSummary=true, when asking for the summary of this FactSource, return staticSummaryContent
     * if staticSummary=false, return the content summarized from the content of this source at runtime
     * the default InlinePassages used HanLP to do runtime summarization
     */
    protected boolean staticSummary=false;

    /**
     * by default, staticSummary=false
     */
    public InlinePassages() {
        this(false, null, new ArrayList<>());
    }
    
    public InlinePassages(boolean staticSummary) {
        this(staticSummary, null, new ArrayList<>());
    }

    public InlinePassages(List<String> passages) {
        this(false, null, passages);
    }
    
    public InlinePassages(boolean staticSummary, List<String> passages) {
        this(staticSummary, null, passages);
    }
    
    public InlinePassages(boolean staticSummary, String staticSummaryContent, List<String> passages) {
        this.staticSummary=staticSummary;
        this.staticSummaryContent=staticSummaryContent;
        this.passages=passages;
    }
    
    public List<String> getPassages() {
        return passages;
    }

    public void setPassages(List<String> passages) {
        this.passages = passages;
    }

    public String getStaticSummaryContent() {
        return staticSummaryContent;
    }

    public void setStaticSummaryContent(String staticSummaryContent) {
        this.staticSummaryContent = staticSummaryContent;
    }

    public boolean isStaticSummary() {
        return staticSummary;
    }

    public void setStaticSummary(boolean staticSummary) {
        this.staticSummary = staticSummary;
    }
    
    

    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Map toJsonPayload(List<Conversation> messages) {
        List passages=new ArrayList<>();
        Map ret=Map.of(
                "inlinePassages", Map.of(
                        "passages", passages
                )
        );
        int index=0;
        for(String str : this.passages){
            passages.add(Map.of(
                    "id", ""+(index++),
                    "content", Map.of(
                            "parts", List.of(
                                    Map.of(
                                            "text", str
                                    )
                            )
                    )
            ));
        }
        return ret;
    }
    
    /**
     * the default InlinePassages used HanLP to do runtime summarization
     * @see rocks.imsofa.ai.puppychatter.gemini.Summarizer
     * @return
     * @throws Exception 
     */
    @Override
    public String getSummary() throws Exception {
        if(this.staticSummary){
            return this.staticSummaryContent;
        }
        StringBuffer buffer=new StringBuffer();
        for(String d : passages){
            buffer.append(d).append("\r\n");
        }
        String allContent=buffer.toString();
        
        if(allContent.length()>20000){
            allContent=Summarizer.getSummary(allContent, 20000);
        }
        return allContent;
    }
    
}
