package rocks.imsofa.ai.puppychatter.ollama;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.kevinsawicki.http.HttpRequest;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.gson.Gson;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatibleInputStreamPuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.Tool;

@SuppressWarnings("all")

public class OllamaPuppyChatter
        extends OpenAICompatibleInputStreamPuppyChatter<OpenAICompatiblePromptParameters, Response> {
    private String model = null;
    private CacheService cacheService = null;

    public OllamaPuppyChatter(String model, CacheService cacheService) {
        super(cacheService, "user");
        this.model = model;
    }

    @Override
    protected StreamResultIterator getStreamResultIterator(RequestParameters requestParameters) throws Exception {
        final HttpRequest request = requestParameters.getHttpRequest();
        return new StreamResultIterator(request.stream()) {
            private BufferedReader reader = null;
            private String nextLine = null;

            @Override
            public String next() {
                return nextLine;
            }

            private void closeReader() {
                if (reader != null) {
                    IOUtils.closeQuietly(reader);
                    reader = null;
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    if (reader == null) {
                        reader = new BufferedReader(new InputStreamReader(request.stream(), "utf-8"));
                    }
                    String line = reader.readLine();
                    if (line == null) {
                        closeReader();
                        return false;
                    }
                    while (line != null) {
                        line = line.trim();
                        // System.out.println("line="+line);
                        if (line.isEmpty() == false) {
                            line = (line.startsWith("{"))?line:line.substring(line.indexOf(" ") + 1);
                            if ("[DONE]".equals(line) == false) {
                                break;
                            }else{
                                line=reader.readLine();
                            }
                        }else{
                            line=reader.readLine();
                        }
                    }
                    if(line==null){
                        closeReader();
                        return false;
                    }
                    nextLine = line;
                    return true;
                } catch (Exception e) {
                    closeReader();
                    return false;
                }
            }

        };
    }

    @Override
    protected RequestParameters getRequestParameters(String sessionId, List<Conversation> messages,
            OpenAICompatiblePromptParameters parameters, boolean streamed) throws Exception {
        RequestParameters requestParameters = new RequestParameters();
        requestParameters.setOriginalMessages(messages);
        requestParameters.setStream(streamed);
        requestParameters.setParameters(parameters);
        requestParameters.setModel(model);

        HttpRequest request = HttpRequest.post("http://localhost:11434/v1/chat/completions")
                .contentType("application/json;charset=utf-8");

        requestParameters.setHttpRequest(request);
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        
        
        requestParameters.setEffectiveMessages(messages);

        return requestParameters;
    }

}
