/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package rocks.imsofa.ai.puppychatter.openrouter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.kevinsawicki.http.HttpRequest;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.google.gson.Gson;

import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatibleInputStreamPuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.Tool;
import rocks.imsofa.ai.puppychatter.openai.ToolCallResponseConversation;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequest;

/**
 * an implementation of PuppyChatter based on Open Router
 * usage:<br/>
 * 
 * PuppyChatter&lt;PromptParameters, Response&gt; chatter=new
 * OpenrouterPuppyChatter("open router key");<br/>
 * String session=chatter.createSession();<br/>
 * Response response=chatter.bark(session, "你好", new
 * PromptParameters("user"));<br/>
 * System.out.println(response.getMessage());<br/>
 * chatter.closeSession(session);<br/>
 * 
 * when issuing prompt, a leading model:xxx can be used to specify the model to
 * use
 * 
 * @author lendle
 */
@SuppressWarnings("all")
public class OpenrouterPuppyChatter
        extends OpenAICompatibleInputStreamPuppyChatter<OpenAICompatiblePromptParameters, Response> {

    private String apiKey = null;
    private String defaultModel = "meta-llama/llama-3.3-70b-instruct:free";

    public OpenrouterPuppyChatter(String apiKey, String defaultModel, CacheService cacheService) {
        this.apiKey = apiKey;
        this.defaultModel = defaultModel;
        this.cacheService = cacheService;
    }

    public OpenrouterPuppyChatter(String apiKey) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", null);
    }

    public OpenrouterPuppyChatter(String apiKey, CacheService cacheService) {
        this(apiKey, "meta-llama/llama-3.3-70b-instruct:free", cacheService);
    }

    private Map getSchemaMap(Class schemaClass) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12,
                OptionPreset.PLAIN_JSON);
        configBuilder.forFields().withRequiredCheck((field) -> {
            JsonProperty annotation = field.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
            return annotation != null && annotation.required();
        });
        SchemaGeneratorConfig config = configBuilder.build();
        Gson gson = new Gson();
        SchemaGenerator generator = new SchemaGenerator(config);
        JsonNode jsonSchema = generator.generateSchema(schemaClass);
        String jsonString = jsonSchema.toString();
        Map schemaMap = new HashMap(gson.fromJson(jsonString, Map.class));
        return schemaMap;
    }

    public static void main(String[] args) throws Exception {
        /*
         * String link =
         * "https://www.imsofa.rocks/post/734650527994036224/2024%E7%94%A8%E8%B6%A3%E5%91%B3%E5%95%9F%E5%8B%95%E7%A8%8B%E5%BC%8F";
         * String content = HttpRequest.get(link).body();
         * OpenrouterPuppyChatter puppyChatter = new OpenrouterPuppyChatter(
         * "sk");
         * String sessionId = puppyChatter.createSession();
         * String prompt =
         * "model:meta-llama/llama-3.1-8b-instruct:free 請從以下的網頁內容，摘要出最重要的內容，並以文字1000字以內表達：\r\n"
         * + content;
         * Response puppyResponse = puppyChatter.bark(sessionId, prompt, new
         * OpenrouterPromptParameters("user"));
         * System.out.println("message=" + puppyResponse.getMessage());
         * puppyChatter.closeSession(sessionId);
         */
    }

    @Override
    protected StreamResultIterator getStreamResultIterator(RequestParameters requestParameters) throws Exception {
        HttpRequest request = requestParameters.getHttpRequest();
        return new StreamResultIterator(request.stream()) {
            private BufferedReader reader = null;
            private String nextLine = null;

            @Override
            public String next() {
                return nextLine;
            }

            private void closeReader() {
                if (reader != null) {
                    IOUtils.closeQuietly(reader);
                    reader = null;
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    if (reader == null) {
                        reader = new BufferedReader(new InputStreamReader(request.stream(), "utf-8"));
                    }
                    String line = reader.readLine();
                    if (line == null) {
                        closeReader();
                        return false;
                    }
                    while (line != null) {
                        line = line.trim();
                        // System.out.println("line="+line);
                        if (line.isEmpty() == false) {
                            line = (line.startsWith("{"))?line:line.substring(line.indexOf(" ") + 1);
                            if ("[DONE]".equals(line) == false && "OPENROUTER PROCESSING".equals(line) == false) {
                                break;
                            }else{
                                line=reader.readLine();
                            }
                        }else{
                            line=reader.readLine();
                        }
                    }
                    if(line==null){
                        closeReader();
                        return false;
                    }
                    // System.out.println("line="+line);
                    nextLine = line;
                    return true;
                } catch (Exception e) {
                    closeReader();
                    return false;
                }
            }

        };
    }

    @Override
    protected RequestParameters getRequestParameters(String sessionId, List<Conversation> messages,
            OpenAICompatiblePromptParameters parameters, boolean streamed) throws Exception {
        RequestParameters requestParameters = new RequestParameters();
        requestParameters.setOriginalMessages(messages);
        requestParameters.setStream(streamed);
        requestParameters.setParameters(parameters);
        requestParameters.setModel(defaultModel);

        HttpRequest request = HttpRequest.post("https://openrouter.ai/api/v1/chat/completions")
                .header("Authorization", "Bearer " + apiKey)
                .contentType("application/json;charset=utf-8");

        requestParameters.setHttpRequest(request);
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent().trim();
        String model = defaultModel;
        if (prompt.startsWith("model:")) {
            // magic string to specify a model
            int index = prompt.indexOf(" ");
            model = prompt.substring("model:".length(), index);
            requestParameters.setModel(model);
        } 
        // process conversation, remove the model: magic string
        List<Conversation> effectiveMessages = (List<Conversation>) messages.stream().map(Conversation::clone).collect(Collectors.toList());
        for (Conversation c : effectiveMessages) {
            // System.out.println(c.getClass());
            String content = c.getContent().trim();
            if (content.startsWith("model:")) {
                int index = content.indexOf(" ");
                content = content.substring(index + 1);
                c.setContent(content);
            }
        }
        requestParameters.setEffectiveMessages(effectiveMessages);

        return requestParameters;
    }

}
