package rocks.imsofa.ai.puppychatter.openrouter;

import java.util.List;

import com.google.gson.Gson;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.rag.AbstractTextRagHandler;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.RagHandler;
import rocks.imsofa.ai.puppychatter.rag.TextChunk;

public class TestRag {
    public static void main(String[] args) throws Exception {
        OpenrouterRagPuppyChatter puppyChatter = new OpenrouterRagPuppyChatter("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", "openai/gpt-4o-mini", null);
        Gson gson=new Gson();

        puppyChatter.setRagHandler(new AbstractTextRagHandler() {

            @Override
            public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) {
                return List.of(
                    new TextChunk("the weather today is very hot")
                );
            }

        });

        String sessionId = puppyChatter.createSession();
        OpenAICompatiblePromptParameters parameters = new OpenAICompatiblePromptParameters("user");
        Response response=puppyChatter.bark(sessionId, "how is the weather today?", parameters);
        puppyChatter.closeSession(sessionId);
        System.out.println(response.getMessage());
    }
}
