package rocks.imsofa.ai.puppychatter.rag;

import java.util.List;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;

public abstract class AbstractTextRagHandler implements RagHandler {

    @Override
    public Conversation transformLastPrompt(String sessionId, PromptParameters parameters, List<Conversation> messages,
            List<Chunk> chunks) {
        Conversation lastConversation = messages.get(messages.size() - 1);
        String prompt = lastConversation.getContent();
        String newPrompt = """
            You will answer my question based on the references. First, I will give you my question in the Question section,
            and then I will give you the references in the References section. You should answer my question based on the references. If you
            cannot answer my question based on the references, please answer with "I cannot answer based on the references".

            Question:
        """.trim()+"\r\n"+prompt+"\r\nReference:";
        for (int i = 0; i < chunks.size(); i++) {
            newPrompt+="\r\n"+(i+1)+".\r\n"+chunks.get(i).getTextContent();
        }
        lastConversation.setContent(newPrompt);
        return lastConversation;
    }

}
