package rocks.imsofa.ai.puppychatter.rag;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

import org.slf4j.LoggerFactory;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.DriveScopes;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.hankcs.hanlp.HanLP;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.rag.drive.DefaultGoogleDriveRagHandlerCallback;
import rocks.imsofa.ai.puppychatter.rag.drive.GoogleDriveFileContentGetter;
import rocks.imsofa.ai.puppychatter.rag.drive.GoogleDriveRagHandlerCallback;

/**
 * a rag handler that use google drive to extract chunks from the conversation
 */
@SuppressWarnings("all")
public class GoogleDriveRagHandler extends AbstractTextRagHandler {
    private String folderId;
    /**
     * The service account key file.
     */
    private java.io.File serviceAccountKeyFile;
    /**
     * The Google application name used in the application name field of the Drive API.
     */
    private String googleApplicationName;
    private GoogleDriveRagHandlerCallback callback;

    public GoogleDriveRagHandler(String folderId, 
        java.io.File serviceAccountKeyFile, String googleApplicationName,
        GoogleDriveRagHandlerCallback callback) {
        this.folderId = folderId;
        this.serviceAccountKeyFile = serviceAccountKeyFile;
        this.googleApplicationName = googleApplicationName;
        this.callback=callback;
    }

    public GoogleDriveRagHandler(String folderId, 
        java.io.File serviceAccountKeyFile, String googleApplicationName) {
        this(folderId, serviceAccountKeyFile, googleApplicationName, new DefaultGoogleDriveRagHandlerCallback(new DefaultTextContentExtractor()));
    }

    @Override
    public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) {
        List<Chunk> chunks = new java.util.ArrayList<>();
        //this is a key for accessing drive search in puppychatter
        try (InputStream keyInputStream = new FileInputStream(serviceAccountKeyFile);) {

            GoogleCredentials credentials = GoogleCredentials.fromStream(keyInputStream)
                    .createScoped(Collections.singleton(DriveScopes.DRIVE));
            JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
            Drive drive = new Drive.Builder(
                    GoogleNetHttpTransport.newTrustedTransport(),
                    JSON_FACTORY,
                    new HttpCredentialsAdapter(credentials))
                    .setApplicationName(googleApplicationName)
                    .build();
            Drive.Files.List list = drive.files().list();
            list.setPageSize(10);
            
            list.setQ(this.callback.getQuery(messages, folderId));
            list.setFields("nextPageToken, files(id, name, modifiedTime, mimeType, fileExtension, createdTime)");
            String nextPageToken = null;
            FileList fileList = list.execute();
            java.util.List<File> files = fileList.getFiles();
            // long totalLength = 0;
            for (int i = 0; i < files.size(); i++) {
                File file = files.get(i);
                if(file.getName().endsWith(".zip")){
                    continue;
                }
                if(!callback.accept(chunks, file)){
                    continue;
                }
                System.out.println(file.getName());
                String textContent = null;
                try {
                    textContent = this.callback.getTextContentExtractor().
                        extractTextContent(messages, GoogleDriveFileContentGetter.getTextContent(drive, file));
                } catch (Exception e) {
                    // System.out.println(file.getName());
                    // e.printStackTrace();
                    continue;
                }

                chunks.add(new TextChunk(textContent));
                // totalLength += textContent.length();
                if(!callback.moveOn(chunks)){
                    break;
                }
               
            }
            nextPageToken = fileList.getNextPageToken();
            // System.out.println("nextPageToken="+nextPageToken);
            list.setPageToken(nextPageToken);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return chunks;
    }

    

}
