package rocks.imsofa.ai.puppychatter.rag;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.cache.TwoLevelFileCache;
import rocks.imsofa.ai.puppychatter.gemini.GoogleSearchFactSource;
import rocks.imsofa.ai.puppychatter.rag.googlesearch.DefaultGoogleSearchRagHandlerCallback;
import rocks.imsofa.ai.puppychatter.rag.googlesearch.GoogleSearchRagHandlerCallback;

/**
 * a rag handler that use google search to extract chunks from the conversation
 */
@SuppressWarnings("all")
public class GoogleSearchRagHandler extends AbstractTextRagHandler{
    private String apiKey;
    private String searchEngineId;

    private TwoLevelFileCache queryResultCache=null, linkCache=null;
    private GoogleSearchRagHandlerCallback callback;


    public GoogleSearchRagHandler(String apiKey, String searchEngineId, GoogleSearchRagHandlerCallback callback) {
        this.apiKey = apiKey;
        this.searchEngineId = searchEngineId;
        this.callback = callback;
    }

    public GoogleSearchRagHandler(String apiKey, String searchEngineId) {
        this(apiKey, searchEngineId, new DefaultGoogleSearchRagHandlerCallback(""));
    }

    @Override
    public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) throws Exception {
        List<Chunk> chunks = new java.util.ArrayList<>();
        File cacheFolder=new File(".cache");
        File googleSearchCache=new File(cacheFolder, ".google");
        File queryResultCacheFolder=new File(googleSearchCache, ".result");
        File linkCacheFolder=new File(googleSearchCache, ".link");
        
        if(queryResultCacheFolder.exists()==false){
            queryResultCacheFolder.mkdirs();
        }
        
        if(linkCacheFolder.exists()==false){
            linkCacheFolder.mkdirs();
        }
        queryResultCache=new TwoLevelFileCache(queryResultCacheFolder);
        linkCache=new TwoLevelFileCache(linkCacheFolder);
        String query = callback.getQuery(messages);
        Map<String, Object> resp=getQueryResult(queryResultCache, apiKey, searchEngineId, query);
        if(resp.containsKey("items")){
            List<String> links=new ArrayList<>();
            @SuppressWarnings("unchecked")
            List<Map<String, String>> items = (List<Map<String, String>>) resp.get("items");
            // System.out.println("items="+items.size());
            for (Map<String, String> item : items) {
                try {
                    String link = item.get("link");
                    if(callback.accept(chunks, link)){
                        links.add(link);
                        String content = getLinkContent(linkCache, messages, link);
                        chunks.add(new TextChunk(content));
                        // System.out.println("link="+link+", content="+content.substring(0, 30));
                        if(!callback.moveOn(chunks)){
                            break;
                        }
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                    // Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    throw new Exception(ex);
                }
            }
        }else{
            throw new Exception("no match in query");
        }
        return chunks;
    }

    private Map<String, Object> getQueryResult(TwoLevelFileCache queryResultCache, String apiKey, String searchEngineId, String query) throws Exception{
        Gson gson=new Gson();
        String queryResultJson=queryResultCache.getFromCache(query);
        if(queryResultJson!=null){
            return gson.fromJson(queryResultJson, Map.class);
        }else{
            HttpRequest request = HttpRequest.get("https://www.googleapis.com/customsearch/v1", true,
                "key", apiKey, "cx", searchEngineId, "q", query);
//            System.out.println("google query="+query);
            String response = request.body();
            Map<String, Object> resp = gson.fromJson(response, Map.class);
            if(resp.containsKey("items")){
                //save to cache
                queryResultCache.save2Cache(query, response);
            }
            return resp;
        }
    } 
    
    private String getLinkContent(TwoLevelFileCache linkCache, List<Conversation> messages, String link) throws Exception{
        String content=linkCache.getFromCache(link);
        if(content!=null){
            return content;
        }else{
            content = this.callback.getHtmlPageContentExtractor().extractTextContent(messages, new URI(link).toURL());
            
            // linkCache.save2Cache(link, content);
            return content;
        }
    }
}
