package rocks.imsofa.ai.puppychatter.rag.drive;

import java.util.List;

import com.google.api.services.drive.model.File;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;

public interface GoogleDriveRagHandlerCallback {
    public TextContentExtractor getTextContentExtractor();
    public String getQuery(List<Conversation> messages, String folderId);
    /**
     * accept the next file
     * @param currentChunks
     * @param nextFile
     * @return
     */
    public boolean accept(List<Chunk> currentChunks, File nextFile);
    /**
     * move on
     * @param chunks
     * @return
     */
    public boolean moveOn(List<Chunk> chunks);
}
