package rocks.imsofa.ai.puppychatter.rag.googlesearch;

import java.util.List;

import com.hankcs.hanlp.HanLP;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.DefaultTextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;

public class DefaultGoogleSearchRagHandlerCallback implements GoogleSearchRagHandlerCallback{
    private String baseQuery;
    private TextContentExtractor htmlPageContentExtractor=new DefaultTextContentExtractor();

    public DefaultGoogleSearchRagHandlerCallback(String baseQuery) {
        this.baseQuery = baseQuery;
    }

    public DefaultGoogleSearchRagHandlerCallback(String baseQuery, TextContentExtractor htmlPageContentExtractor) {
        this.baseQuery = baseQuery;
        this.htmlPageContentExtractor = htmlPageContentExtractor;
    }

    @Override
    public String getQuery(List<Conversation> messages) {
        String conversation = messages.get(messages.size() - 1).getContent();
        if(conversation.startsWith("model:")){
            conversation=conversation.trim();
            conversation=conversation.substring(conversation.indexOf(" ")+1);
        }
        List<String> keywords = HanLP.extractKeyword(conversation, 5);
        String query = baseQuery + " \"" + String.join("\" | \"", keywords) + "\"";
        return query;
    }

    @Override
    public boolean accept(List<Chunk> currentChunks, String link) {
        return true;
    }

    @Override
    public boolean moveOn(List<Chunk> chunks) {
        long totalLength=0;
        for(Chunk chunk:chunks){
            totalLength+=chunk.getTextContent().length();
        }
        // System.out.println("totalLength="+totalLength);
        return totalLength<10000;
    }

    @Override
    public TextContentExtractor getHtmlPageContentExtractor() {
        return this.htmlPageContentExtractor;
    }
}
