package rocks.imsofa.ai.puppychatter.rag.googlesearch;

import java.util.List;

import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.TextContentExtractor;

public interface GoogleSearchRagHandlerCallback {
    public String getQuery(List<Conversation> messages);
    public TextContentExtractor getHtmlPageContentExtractor();
    /**
     * accept the next file
     * @param currentChunks
     * @param link
     * @return
     */
    public boolean accept(List<Chunk> currentChunks, String link);
    /**
     * move on
     * @param chunks
     * @return
     */
    public boolean moveOn(List<Chunk> chunks);
}
