/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.BarkCallback;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.VerificationResult;
import rocks.imsofa.ai.puppychatter.cache.CacheService;

public abstract class AbstractPuppyChatter<T extends PromptParameters, S extends Response>
implements PuppyChatter<T, S> {
    protected Map<String, List<Conversation>> sessionHistory = new HashMap<String, List<Conversation>>();
    protected CacheService cacheService = null;
    protected String replyRole = "assistant";

    public AbstractPuppyChatter(CacheService cacheService, String replyRole) {
        this.cacheService = cacheService;
        this.replyRole = replyRole;
    }

    public AbstractPuppyChatter() {
    }

    @Override
    public String createSession() {
        String sessionId = UUID.randomUUID().toString();
        this.sessionHistory.put(sessionId, new ArrayList());
        return sessionId;
    }

    @Override
    public void bark(String sessionId, String prompt, T parameters, BarkCallback<S> barkCallback) throws BarkException {
        this._bark(sessionId, prompt, parameters, barkCallback);
    }

    @Override
    public S bark(String sessionId, String prompt, T parameters) throws BarkException {
        return this._bark(sessionId, prompt, parameters, null);
    }

    @Override
    public void bark(String sessionId, String prompt, BarkCallback<S> barkCallback) throws BarkException {
        this.bark(sessionId, prompt, this.createDefaultPromptParameter(), barkCallback);
    }

    @Override
    public S bark(String sessionId, String prompt) throws BarkException {
        return this.bark(sessionId, prompt, this.createDefaultPromptParameter());
    }

    @Override
    public void closeSession(String sessionId) {
        this.sessionHistory.remove(sessionId);
    }

    private S _bark(String sessionId, String prompt, T parameters, BarkCallback<S> barkCallback) throws BarkException {
        boolean cacheable;
        List<Conversation> messages;
        block19: {
            messages = this.sessionHistory.get(sessionId);
            Conversation newMessage = this.createConversationFromPrompt(prompt, parameters);
            messages.add(newMessage);
            cacheable = this.isCacheable(sessionId, messages, parameters);
            if (this.cacheService != null && cacheable) {
                try {
                    messages = this.cacheService.sync2BoundConversations(messages);
                }
                catch (Exception ex) {
                    throw new BarkException(ex);
                }
            }
            this.sessionHistory.put(sessionId, messages);
            if (this.cacheService != null && cacheable) {
                S response;
                block20: {
                    try {
                        Conversation c = this.cacheService.getCachedReply(messages);
                        if (c == null) break block19;
                        response = this.createResponseFromConversation(messages, c);
                        if (!((PromptParameters)parameters).getResponseVerifier().verify((Response)response).equals((Object)VerificationResult.GOOD)) break block19;
                        LoggerFactory.getLogger(this.getClass()).info("reply obtained from cache");
                        messages.add(c);
                        if (barkCallback == null) break block20;
                        barkCallback.responseChunkReceived(response, true);
                    }
                    catch (Exception ex) {
                        throw new BarkException(ex);
                    }
                    return null;
                }
                return response;
            }
        }
        LoggerFactory.getLogger(this.getClass()).info("cache not available, bark at the underlying service");
        if (barkCallback != null) {
            try {
                this._bark(sessionId, messages, parameters, barkCallback);
            }
            catch (Exception ex) {
                Logger.getLogger(AbstractPuppyChatter.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }
        Response response = null;
        try {
            response = (Response)this._bark(sessionId, messages, parameters);
        }
        catch (Exception ex) {
            System.out.println("something wrong " + String.valueOf(ex));
            throw new BarkException(ex);
        }
        VerificationResult responseQuality = ((PromptParameters)parameters).getResponseVerifier().verify(response);
        LoggerFactory.getLogger(this.getClass()).info("verification result: " + String.valueOf((Object)responseQuality));
        while (responseQuality.equals((Object)VerificationResult.TRY_AGAIN)) {
            try {
                response = this._bark(sessionId, messages, parameters);
                responseQuality = ((PromptParameters)parameters).getResponseVerifier().verify(response);
                LoggerFactory.getLogger(this.getClass()).info("verification result: " + String.valueOf((Object)responseQuality));
            }
            catch (Exception ex) {
                throw new BarkException(ex);
            }
        }
        if (responseQuality.equals((Object)VerificationResult.GOOD)) {
            Conversation replyMessage = new Conversation(this.replyRole, response.getMessage());
            if (this.cacheService != null && cacheable) {
                try {
                    messages = this.cacheService.sync2BoundConversations(messages);
                    this.cacheService.cacheReply(messages, replyMessage);
                }
                catch (Exception ex) {
                    throw new BarkException(ex);
                }
            }
            messages.add(replyMessage);
            this.sessionHistory.put(sessionId, messages);
            return (S)response;
        }
        response.setError(true);
        throw new BarkException(response);
    }

    protected abstract S _bark(String var1, List<Conversation> var2, T var3) throws Exception;

    protected abstract void _bark(String var1, List<Conversation> var2, T var3, BarkCallback<S> var4) throws Exception;

    protected abstract T createDefaultPromptParameter();

    protected abstract S createResponseFromConversation(List<Conversation> var1, Conversation var2);

    protected Conversation createConversationFromPrompt(String prompt, T parameters) {
        return new Conversation(((PromptParameters)parameters).getRole(), prompt);
    }

    protected boolean isCacheable(String sessionId, List<Conversation> messages, T parameters) {
        return true;
    }
}

