/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.cache.TwoLevelFileCache;
import rocks.imsofa.ai.puppychatter.gemini.GoogleSearchFactSource;
import rocks.imsofa.ai.puppychatter.gemini.GoogleSearchHandler;
import rocks.imsofa.ai.puppychatter.gemini.KeywordExtractor;

public abstract class AbstractGoogleSearchHandler
implements GoogleSearchHandler {
    private TwoLevelFileCache queryResultCache = null;
    private TwoLevelFileCache linkCache = null;

    @Override
    public List<String> search(String apiKey, String searchEngineId, String query) throws Exception {
        File cacheFolder = new File(".cache");
        File googleSearchCache = new File(cacheFolder, ".google");
        File queryResultCacheFolder = new File(googleSearchCache, ".result");
        File linkCacheFolder = new File(googleSearchCache, ".link");
        if (!queryResultCacheFolder.exists()) {
            queryResultCacheFolder.mkdirs();
        }
        if (!linkCacheFolder.exists()) {
            linkCacheFolder.mkdirs();
        }
        this.queryResultCache = new TwoLevelFileCache(queryResultCacheFolder);
        this.linkCache = new TwoLevelFileCache(linkCacheFolder);
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, Object> resp = this.getQueryResult(this.queryResultCache, apiKey, searchEngineId, query);
        if (resp.containsKey("items")) {
            ArrayList<String> links = new ArrayList<String>();
            List items = (List)resp.get("items");
            for (Map item : items) {
                try {
                    String link = (String)item.get("link");
                    if (!this.shouldIncludeLink(link)) continue;
                    links.add(link);
                    String content = this.getLinkContent(this.linkCache, link);
                    String summary = this.summarizePageContent(content);
                    ret.add(summary);
                    if (this.shouldGoNextLink(links)) continue;
                    break;
                }
                catch (Exception ex) {
                    Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            throw new Exception("no match in query");
        }
        return ret;
    }

    private String getLinkContent(TwoLevelFileCache linkCache, String link) throws Exception {
        String content = linkCache.getFromCache(link);
        if (content != null) {
            return content;
        }
        content = HttpRequest.get((CharSequence)link).body();
        linkCache.save2Cache(link, content);
        return content;
    }

    private Map<String, Object> getQueryResult(TwoLevelFileCache queryResultCache, String apiKey, String searchEngineId, String query) throws Exception {
        Gson gson = new Gson();
        String queryResultJson = queryResultCache.getFromCache(query);
        if (queryResultJson != null) {
            return (Map)gson.fromJson(queryResultJson, Map.class);
        }
        HttpRequest request = HttpRequest.get((CharSequence)"https://www.googleapis.com/customsearch/v1", (boolean)true, (Object[])new Object[]{"key", apiKey, "cx", searchEngineId, "q", query});
        String response = request.body();
        Map resp = (Map)gson.fromJson(response, Map.class);
        if (resp.containsKey("items")) {
            queryResultCache.save2Cache(query, response);
        }
        return resp;
    }

    @Override
    public String constructQueryForConversation(String conversationBaseQuery, List<Conversation> messages) throws Exception {
        String conversation = messages.get(messages.size() - 1).getContent();
        List<String> keywords = KeywordExtractor.getKeywords(conversation, 2);
        String query = conversationBaseQuery + " \"" + String.join((CharSequence)"\" | \"", keywords) + "\"";
        return query;
    }

    public abstract boolean shouldIncludeLink(String var1);

    public abstract boolean shouldGoNextLink(List<String> var1);

    public abstract String summarizePageContent(String var1) throws Exception;

    @Override
    public String constructQueryForSummary(String summaryBaseQuery) throws Exception {
        return summaryBaseQuery;
    }
}

