/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.gemini.AbstractGoogleSearchHandler;
import rocks.imsofa.ai.puppychatter.gemini.GoogleSearchHandler;
import rocks.imsofa.ai.puppychatter.gemini.InternalPuppyChatterInitializer;
import rocks.imsofa.ai.puppychatter.gemini.PreparedInlinePassages;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;

public class GoogleSearchFactSource
extends PreparedInlinePassages {
    private String apiKey = null;
    private String searchEngineId = null;
    private String conversationBaseQuery = "";
    private String summaryBaseQuery = "";
    private PuppyChatter puppyChatter = null;
    private GoogleSearchHandler googleSearchHandler = null;

    public GoogleSearchFactSource(String apiKey, String searchEngineId, String conversationBaseQuery, String summaryBaseQuery, GoogleSearchHandler googleSearchHandler) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, summaryBaseQuery, googleSearchHandler);
    }

    public GoogleSearchFactSource(String apiKey, String searchEngineId, String conversationBaseQuery, String summaryBaseQuery) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, summaryBaseQuery, null);
        this.googleSearchHandler = new DefaultGoogleSearchHandler(this.puppyChatter);
    }

    public GoogleSearchFactSource(boolean staticSummary, String staticSummaryContent, String apiKey, String searchEngineId, String conversationBaseQuery, String summaryBaseQuery, GoogleSearchHandler googleSearchHandler) {
        this.staticSummary = staticSummary;
        this.staticSummaryContent = staticSummaryContent;
        this.apiKey = apiKey;
        this.searchEngineId = searchEngineId;
        this.conversationBaseQuery = conversationBaseQuery;
        this.summaryBaseQuery = summaryBaseQuery;
        File cacheFolder = new File(".cache");
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
        this.puppyChatter = InternalPuppyChatterInitializer.getPuppyChatter();
        this.googleSearchHandler = googleSearchHandler;
    }

    public GoogleSearchFactSource(boolean staticSummary, String staticSummaryContent, String apiKey, String searchEngineId, String conversationBaseQuery, GoogleSearchHandler googleSearchHandler) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, null, googleSearchHandler);
    }

    public GoogleSearchFactSource(boolean staticSummary, String staticSummaryContent, String apiKey, String searchEngineId, String conversationBaseQuery) {
        this(false, null, apiKey, searchEngineId, conversationBaseQuery, null, null);
        this.googleSearchHandler = new DefaultGoogleSearchHandler(this.puppyChatter);
    }

    public static void main(String[] args) throws Exception {
    }

    @Override
    protected void preparePassages(List<Conversation> messages) throws BarkException {
        try {
            String query = this.googleSearchHandler.constructQueryForConversation(this.conversationBaseQuery, messages);
            if (this.passages == null) {
                this.passages = new ArrayList();
            }
            try {
                List<String> contents = this.googleSearchHandler.search(this.apiKey, this.searchEngineId, query);
                this.passages.addAll(contents);
            }
            catch (Exception e) {
                throw new BarkException(e);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getSummary() throws Exception {
        try {
            String query = this.googleSearchHandler.constructQueryForSummary(this.summaryBaseQuery);
            StringBuffer ret = new StringBuffer();
            try {
                List<String> contents = this.googleSearchHandler.search(this.apiKey, this.searchEngineId, query);
                for (String content : contents) {
                    if (ret.length() != 0) {
                        ret.append("\r\n");
                    }
                    ret.append(content);
                }
                return ret.toString();
            }
            catch (Exception e) {
                throw new BarkException(e);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(GoogleSearchFactSource.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static class DefaultGoogleSearchHandler
    extends AbstractGoogleSearchHandler {
        private PuppyChatter puppyChatter = null;

        public DefaultGoogleSearchHandler(PuppyChatter puppyChatter) {
            this.puppyChatter = puppyChatter;
        }

        @Override
        public boolean shouldIncludeLink(String link) {
            return true;
        }

        @Override
        public String summarizePageContent(String html) throws Exception {
            String sessionId = this.puppyChatter.createSession();
            String prompt = "\u8acb\u5f9e\u4ee5\u4e0b\u7684\u7db2\u9801\u5167\u5bb9\uff0c\u6458\u8981\u51fa\u6700\u91cd\u8981\u7684\u5167\u5bb9\uff0c\u4e26\u4ee5\u6587\u5b571000\u5b57\u4ee5\u5167\u8868\u9054\uff1a\r\n" + html;
            Object puppyResponse = this.puppyChatter.bark(sessionId, prompt, new OpenAICompatiblePromptParameters("user"));
            this.puppyChatter.closeSession(sessionId);
            return ((Response)puppyResponse).getMessage();
        }

        @Override
        public boolean shouldGoNextLink(List<String> processedLinks) {
            return processedLinks.size() < 5;
        }
    }
}

