/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.gemini.FactSource;
import rocks.imsofa.ai.puppychatter.gemini.Summarizer;

public class InlinePassages
implements FactSource {
    protected List<String> passages = new ArrayList<String>();
    protected String staticSummaryContent = null;
    protected boolean staticSummary = false;

    public InlinePassages() {
        this(false, null, new ArrayList<String>());
    }

    public InlinePassages(boolean staticSummary) {
        this(staticSummary, null, new ArrayList<String>());
    }

    public InlinePassages(List<String> passages) {
        this(false, null, passages);
    }

    public InlinePassages(boolean staticSummary, List<String> passages) {
        this(staticSummary, null, passages);
    }

    public InlinePassages(boolean staticSummary, String staticSummaryContent, List<String> passages) {
        this.staticSummary = staticSummary;
        this.staticSummaryContent = staticSummaryContent;
        this.passages = passages;
    }

    public List<String> getPassages() {
        return this.passages;
    }

    public void setPassages(List<String> passages) {
        this.passages = passages;
    }

    public String getStaticSummaryContent() {
        return this.staticSummaryContent;
    }

    public void setStaticSummaryContent(String staticSummaryContent) {
        this.staticSummaryContent = staticSummaryContent;
    }

    public boolean isStaticSummary() {
        return this.staticSummary;
    }

    public void setStaticSummary(boolean staticSummary) {
        this.staticSummary = staticSummary;
    }

    @Override
    public Map toJsonPayload(List<Conversation> messages) {
        ArrayList<Map<String, Map<String, List<Map<String, String>>>>> passages = new ArrayList<Map<String, Map<String, List<Map<String, String>>>>>();
        Map ret = Map.of("inlinePassages", Map.of("passages", passages));
        int index = 0;
        for (String str : this.passages) {
            passages.add(Map.of("id", "" + index++, "content", Map.of("parts", List.of(Map.of("text", str)))));
        }
        return ret;
    }

    @Override
    public String getSummary() throws Exception {
        if (this.staticSummary) {
            return this.staticSummaryContent;
        }
        StringBuffer buffer = new StringBuffer();
        for (String d : this.passages) {
            buffer.append(d).append("\r\n");
        }
        String allContent = buffer.toString();
        if (allContent.length() > 20000) {
            allContent = Summarizer.getSummary(allContent, 20000);
        }
        return allContent;
    }
}

