/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.google.gson.Gson;
import com.hankcs.lucene.HanLPAnalyzer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PuppyChatter;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.gemini.InlinePassages;
import rocks.imsofa.ai.puppychatter.gemini.InternalPuppyChatterInitializer;
import rocks.imsofa.ai.puppychatter.gemini.Summarizer;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;

public class LuceneFactSource
extends InlinePassages {
    private File indexDirectory = null;
    private PuppyChatter puppyChatter = null;

    public LuceneFactSource(File indexDirectory) {
        this.indexDirectory = indexDirectory;
        File cacheFolder = new File(".cache");
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
        this.puppyChatter = InternalPuppyChatterInitializer.getPuppyChatter();
    }

    @Override
    public Map toJsonPayload(List<Conversation> messages) {
        if (this.passages == null || this.passages.isEmpty()) {
            String sessionId = this.puppyChatter.createSession();
            Gson gson = new Gson();
            try {
                String conversation = messages.get(messages.size() - 1).getContent();
                String prompt = "\u8acb\u5f9e\u4ee5\u4e0b\u7684\u6587\u5b57\u5167\u5bb9\uff0c\u64f7\u53d6\u51fa\u5169\u500b\u95dc\u9375\u5b57\uff0c\u6bcf\u500b\u95dc\u9375\u5b57\u81f3\u5c11\u5305\u542b\u5169\u500b\u5b57,\u4e26\u4ee5json\u9663\u5217\u7684\u65b9\u5f0f\u56de\u50b3\uff0c\u683c\u5f0f\u7232 [\u95dc\u9375\u5b571,\u95dc\u9375\u5b572]\uff1a\r\n" + conversation;
                Object puppyResponse = this.puppyChatter.bark(sessionId, prompt, new OpenAICompatiblePromptParameters("user"));
                List keywords = (List)gson.fromJson(((Response)puppyResponse).getMessage("application/json"), List.class);
                StringBuffer queryStringTitle = new StringBuffer();
                StringBuffer queryStringText = new StringBuffer();
                for (String keyword : keywords) {
                    if (queryStringTitle.length() != 0) {
                        queryStringTitle.append(" OR ");
                    }
                    if (queryStringText.length() != 0) {
                        queryStringText.append(" OR ");
                    }
                    queryStringTitle.append("(title:" + keyword + ")");
                    queryStringText.append("(text:" + keyword + ")");
                }
                String queryString = "(" + queryStringText.toString() + ") OR (" + String.valueOf(queryStringTitle) + ")";
                LoggerFactory.getLogger((String)this.getClass().getName()).info("use lucene query: " + queryString);
                Path indexPath = Files.createDirectories(this.indexDirectory.toPath(), new FileAttribute[0]);
                FSDirectory directory = FSDirectory.open((Path)indexPath);
                DirectoryReader ireader = DirectoryReader.open((Directory)directory);
                IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
                HanLPAnalyzer analyzer = new HanLPAnalyzer();
                MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(new String[]{"title", "text"}, (Analyzer)analyzer);
                Query query = multiFieldQueryParser.parse(queryString);
                LoggerFactory.getLogger((String)this.getClass().getName()).info("use lucene query: " + queryString);
                TopDocs topDocs = isearcher.search(query, 5);
                int i = 0;
                while (i < topDocs.scoreDocs.length) {
                    Document hitDoc = isearcher.doc(topDocs.scoreDocs[i].doc);
                    String text = hitDoc.get("text");
                    prompt = "\u8acb\u5f9e\u4ee5\u4e0b\u7684\u6587\u5b57\u5167\u5bb9\uff0c\u6458\u8981\u51fa\u6700\u91cd\u8981\u7684\u5167\u5bb9\uff0c\u4ee5\u80fd\u56de\u7b54\"" + conversation + "\"\u7232\u76ee\u6a19\uff0c\u4e26\u4ee5\u6587\u5b571000\u5b57\u4ee5\u5167\u8868\u9054\uff1a\r\n" + text;
                    puppyResponse = this.puppyChatter.bark(sessionId, prompt, new OpenAICompatiblePromptParameters("user"));
                    this.passages.add(((Response)puppyResponse).getMessage());
                    ++i;
                }
                ireader.close();
                directory.close();
                return super.toJsonPayload(messages);
            }
            catch (Exception ex) {
                Logger.getLogger(LuceneFactSource.class.getName()).log(Level.SEVERE, null, ex);
                this.puppyChatter.closeSession(sessionId);
            }
        }
        return super.toJsonPayload(messages);
    }

    @Override
    public String getSummary() throws Exception {
        Path indexPath = Files.createDirectories(this.indexDirectory.toPath(), new FileAttribute[0]);
        FSDirectory directory = FSDirectory.open((Path)indexPath);
        DirectoryReader ireader = DirectoryReader.open((Directory)directory);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        HanLPAnalyzer analyzer = new HanLPAnalyzer();
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(new String[]{"title", "text"}, (Analyzer)analyzer);
        Query query = multiFieldQueryParser.parse("*:*");
        TopDocs topDocs = isearcher.search(query, 100);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < topDocs.scoreDocs.length) {
            Document hitDoc = isearcher.doc(topDocs.scoreDocs[i].doc);
            String text = hitDoc.get("text");
            buffer.append(text).append("\r\n");
            ++i;
        }
        ireader.close();
        directory.close();
        return Summarizer.getSummary(buffer.toString(), 20000);
    }

    public static void main(String[] args) throws Exception {
        LuceneFactSource factSource = new LuceneFactSource(new File("/home/lendle/dev/projects/1112/AdvisoryCenterKeywords/lucene/index/"));
        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "\u53f0\u7063\u7d93\u6fdf\u60c5\u6cc1"))));
    }
}

