/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.gemini;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.BarkException;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.gemini.KeywordExtractor;
import rocks.imsofa.ai.puppychatter.gemini.PreparedInlinePassages;
import rocks.imsofa.ai.puppychatter.gemini.Summarizer;

public class TavilyFactSource
extends PreparedInlinePassages {
    private String tavilyAPIKey = null;
    private String site = null;

    public TavilyFactSource(String tavilyAPIKey, String site, String staticSummaryContent) {
        super(true, staticSummaryContent, new ArrayList<String>());
        this.tavilyAPIKey = tavilyAPIKey;
        this.site = site;
    }

    public TavilyFactSource(String tavilyAPIKey, String site) {
        this(tavilyAPIKey, site, null);
    }

    @Override
    protected void preparePassages(List<Conversation> messages) throws BarkException {
        this.passages.clear();
        Gson gson = new Gson();
        String conversation = messages.get(messages.size() - 1).getContent();
        List<String> keywords = KeywordExtractor.getKeywords(conversation, 5);
        String query = " \"" + String.join((CharSequence)"\" OR \"", keywords) + "\"";
        Map<String, List<String>> request = Map.of("query", query, "api_key", this.tavilyAPIKey, "include_domains", List.of(this.site));
        String str = HttpRequest.post((CharSequence)"https://api.tavily.com/search").contentType("application/json;charset=utf-8").send((CharSequence)gson.toJson(request)).body();
        System.out.println("tavily request:" + gson.toJson(request));
        System.out.println("tavily result:" + str);
        Map result = (Map)gson.fromJson(str, Map.class);
        List list = (List)result.get("results");
        int wordCount = 0;
        int i = 0;
        while (i < list.size()) {
            Map queryReturn = (Map)list.get(i);
            String content = (String)queryReturn.get("content");
            int nextWordCount = wordCount + content.length();
            if (nextWordCount > 6000) {
                if (wordCount > 3000) break;
                content = Summarizer.getSummary(content, 1000);
            }
            this.passages.add(content);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        TavilyFactSource factSource = new TavilyFactSource("...", "");
        System.out.println(factSource.toJsonPayload(List.of(new Conversation("user", "\u8acb\u6bd4\u8f03java\u548cpython"))));
    }
}

