/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.ollama;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.ollama.OllamaPuppyChatter;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.Tool;
import rocks.imsofa.ai.puppychatter.openai.ToolCallProcessor;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequest;

public class Test {
    public static void main(String[] args) throws Exception {
        OllamaPuppyChatter chatter = new OllamaPuppyChatter("qwen3:0.6b", null);
        String sessionId = chatter.createSession();
        OpenAICompatiblePromptParameters parameters = new OpenAICompatiblePromptParameters("user");
        parameters.setTools(List.of(new Tool("adder", "add two numbers", FunctionParameters.class), new Tool("normalize", "get the normalized number of the given argument", FunctionParameters2.class)));
        chatter.setToolCallProcessor(new ToolCallProcessor(){

            @Override
            public String processToolCallRequest(ToolCallRequest request) {
                Gson gson = new Gson();
                Map arguments = (Map)gson.fromJson(request.getFunction().getArguments(), Map.class);
                if ("adder".equals(request.getFunction().getName())) {
                    Double a = Double.parseDouble(String.valueOf(arguments.get("a")));
                    Double b = Double.parseDouble(String.valueOf(arguments.get("b")));
                    return "" + (a + b);
                }
                if ("normalize".equals(request.getFunction().getName())) {
                    Double a = Double.parseDouble(String.valueOf(arguments.get("a")));
                    return "" + Math.pow(a.intValue(), 2.0);
                }
                return null;
            }
        });
        Object response = chatter.bark(sessionId, "use the adder tool to calculate the added number of 1, 3, and then use the normalize tool to calculate the square of the number", parameters);
        System.out.println("message=" + ((Response)response).getMessage());
        chatter.closeSession(sessionId);
    }

    public static class FunctionParameters {
        @JsonProperty(required=true)
        private int a;
        @JsonProperty(required=true)
        private int b;

        public FunctionParameters(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }
    }

    public static class FunctionParameters2 {
        @JsonProperty(required=true)
        private int a;

        public FunctionParameters2(int a, int b) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }
    }

    public static class LanguageDescription {
        @JsonProperty(required=true)
        private String name;
        @JsonProperty(required=true)
        private String description;
        private List<String> versions;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public void setVersions(List<String> versions) {
            this.versions = versions;
        }
    }
}

