/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.openai;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import rocks.imsofa.ai.puppychatter.AbstractPuppyChatter;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.Response;
import rocks.imsofa.ai.puppychatter.cache.CacheService;
import rocks.imsofa.ai.puppychatter.openai.OpenAICompatiblePromptParameters;
import rocks.imsofa.ai.puppychatter.openai.ToolCallProcessor;
import rocks.imsofa.ai.puppychatter.openai.ToolCallRequest;

public abstract class OpenAICompatiblePuppyChatter<S extends OpenAICompatiblePromptParameters, T extends Response>
extends AbstractPuppyChatter<S, T> {
    protected ToolCallProcessor toolCallProcessor;
    protected Map<String, Map<String, ToolCallRequest>> toolCallRequests = new HashMap<String, Map<String, ToolCallRequest>>();

    public OpenAICompatiblePuppyChatter() {
    }

    public OpenAICompatiblePuppyChatter(String replyRole) {
        super(null, replyRole);
    }

    public OpenAICompatiblePuppyChatter(CacheService cacheService, String replyRole) {
        super(cacheService, replyRole);
    }

    public ToolCallProcessor getToolCallProcessor() {
        return this.toolCallProcessor;
    }

    public void setToolCallProcessor(ToolCallProcessor toolCallProcessor) {
        this.toolCallProcessor = toolCallProcessor;
    }

    @Override
    protected S createDefaultPromptParameter() {
        return (S)new OpenAICompatiblePromptParameters("user");
    }

    @Override
    protected T createResponseFromConversation(List<Conversation> lastPrompt, Conversation lastResponse) {
        Response response = new Response();
        response.setLastPrompt(List.copyOf(lastPrompt));
        response.setError(false);
        response.setMessage(lastResponse.getContent());
        return (T)response;
    }

    @Override
    protected boolean isCacheable(String sessionId, List<Conversation> messages, S parameters) {
        if (((OpenAICompatiblePromptParameters)parameters).getTools() != null && ((OpenAICompatiblePromptParameters)parameters).getTools().size() > 0) {
            if (this.cacheService != null) {
                LoggerFactory.getLogger(this.getClass()).warn("tools are not cacheable");
            }
            return false;
        }
        return super.isCacheable(sessionId, messages, parameters);
    }
}

