/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rocks.imsofa.ai.puppychatter.Conversation;
import rocks.imsofa.ai.puppychatter.PromptParameters;
import rocks.imsofa.ai.puppychatter.rag.AbstractTextRagHandler;
import rocks.imsofa.ai.puppychatter.rag.Chunk;
import rocks.imsofa.ai.puppychatter.rag.DefaultTextContentExtractor;
import rocks.imsofa.ai.puppychatter.rag.TextChunk;
import rocks.imsofa.ai.puppychatter.rag.drive.DefaultGoogleDriveRagHandlerCallback;
import rocks.imsofa.ai.puppychatter.rag.drive.GoogleDriveFileContentGetter;
import rocks.imsofa.ai.puppychatter.rag.drive.GoogleDriveRagHandlerCallback;

public class GoogleDriveRagHandler
extends AbstractTextRagHandler {
    private String folderId;
    private File serviceAccountKeyFile;
    private String googleApplicationName;
    private GoogleDriveRagHandlerCallback callback;

    public GoogleDriveRagHandler(String folderId, File serviceAccountKeyFile, String googleApplicationName, GoogleDriveRagHandlerCallback callback) {
        this.folderId = folderId;
        this.serviceAccountKeyFile = serviceAccountKeyFile;
        this.googleApplicationName = googleApplicationName;
        this.callback = callback;
    }

    public GoogleDriveRagHandler(String folderId, File serviceAccountKeyFile, String googleApplicationName) {
        this(folderId, serviceAccountKeyFile, googleApplicationName, new DefaultGoogleDriveRagHandlerCallback(new DefaultTextContentExtractor()));
    }

    @Override
    public List<Chunk> getChunks(String sessionId, PromptParameters parameters, List<Conversation> messages) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream keyInputStream = new FileInputStream(this.serviceAccountKeyFile);){
                GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)keyInputStream).createScoped(Collections.singleton("https://www.googleapis.com/auth/drive"));
                GsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
                Drive drive = new Drive.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName(this.googleApplicationName).build();
                Drive.Files.List list = drive.files().list();
                list.setPageSize(Integer.valueOf(10));
                list.setQ(this.callback.getQuery(messages, this.folderId));
                list.setFields("nextPageToken, files(id, name, modifiedTime, mimeType, fileExtension, createdTime)");
                String nextPageToken = null;
                FileList fileList = (FileList)list.execute();
                List files = fileList.getFiles();
                int i = 0;
                while (i < files.size()) {
                    block15: {
                        com.google.api.services.drive.model.File file = (com.google.api.services.drive.model.File)files.get(i);
                        if (!file.getName().endsWith(".zip") && this.callback.accept(chunks, file)) {
                            System.out.println(file.getName());
                            String textContent = null;
                            try {
                                textContent = this.callback.getTextContentExtractor().extractTextContent(messages, GoogleDriveFileContentGetter.getTextContent(drive, file));
                            }
                            catch (Exception e) {
                                break block15;
                            }
                            chunks.add(new TextChunk(textContent));
                            if (!this.callback.moveOn(chunks)) break;
                        }
                    }
                    ++i;
                }
                nextPageToken = fileList.getNextPageToken();
                list.setPageToken(nextPageToken);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return chunks;
    }
}

