/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.ai.puppychatter.rag.drive;

import com.google.api.services.drive.Drive;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import rocks.imsofa.utils.text.extractors.TextExtractors;

public class GoogleDriveFileContentGetter {
    public static synchronized String getTextContent(Drive drive, com.google.api.services.drive.model.File file) throws Exception {
        String textContent;
        Serializable cachedFile;
        Gson gson;
        Map indexMap;
        File indexFile;
        File contentCacheRoot;
        block20: {
            Object var10_12;
            Long lastModified;
            File cacheRoot = new File(".cache");
            contentCacheRoot = new File(cacheRoot, ".driveContent");
            indexFile = new File(contentCacheRoot, ".index");
            contentCacheRoot.mkdirs();
            indexMap = null;
            gson = new Gson();
            indexMap = indexFile.exists() ? (Map)gson.fromJson(FileUtils.readFileToString((File)indexFile, (String)"utf-8"), Map.class) : new HashMap();
            Map fileInfo = (Map)indexMap.get(file.getId());
            if (fileInfo != null && (lastModified = Long.valueOf(((Double)fileInfo.get("lastModified")).longValue())) >= file.getModifiedTime().getValue() && ((File)(cachedFile = new File(contentCacheRoot, (String)fileInfo.get("cachedFileName")))).exists()) {
                return FileUtils.readFileToString((File)cachedFile, (String)"utf-8");
            }
            textContent = null;
            if (file.getMimeType().contains("google")) {
                cachedFile = null;
                var10_12 = null;
                try (InputStream input = drive.files().export(file.getId(), "text/plain").executeAsInputStream();){
                    textContent = IOUtils.toString((InputStream)input, (String)"utf-8");
                    break block20;
                }
                catch (Throwable throwable) {
                    if (cachedFile == null) {
                        cachedFile = throwable;
                    } else if (cachedFile != throwable) {
                        ((Throwable)cachedFile).addSuppressed(throwable);
                    }
                    throw cachedFile;
                }
            }
            cachedFile = null;
            var10_12 = null;
            try (InputStream input = drive.files().get(file.getId()).executeMediaAsInputStream();){
                File tempFile = File.createTempFile(".temp_", file.getName());
                FileUtils.copyToFile((InputStream)input, (File)tempFile);
                String str = TextExtractors.getDefaultInstance().extractText(tempFile);
                FileUtils.forceDelete((File)tempFile);
                textContent = str;
            }
            catch (Throwable throwable) {
                if (cachedFile == null) {
                    cachedFile = throwable;
                } else if (cachedFile != throwable) {
                    ((Throwable)cachedFile).addSuppressed(throwable);
                }
                throw cachedFile;
            }
        }
        cachedFile = new File(contentCacheRoot, file.getId() + ".txt");
        FileUtils.write((File)cachedFile, (CharSequence)textContent, (String)"utf-8");
        long lastModified = file.getModifiedTime() != null ? file.getModifiedTime().getValue() : file.getCreatedTime().getValue();
        Map<String, String> newEntry = Map.of("lastModified", lastModified, "cachedFileName", ((File)cachedFile).getName());
        indexMap.put(file.getId(), newEntry);
        FileUtils.write((File)indexFile, (CharSequence)gson.toJson(indexMap), (String)"utf-8");
        return textContent;
    }
}

