package rocks.imsofa.sjl;

import java.util.Objects;

public class ActionCommand {
    private String packageName;
    private String actionName;

    public ActionCommand(String packageName, String actionName) {
        this.packageName = packageName;
        this.actionName = actionName;
    }

    public ActionCommand() {
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getActionName() {
        return actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;

        ActionCommand that = (ActionCommand) o;
        return Objects.equals(packageName, that.packageName) && Objects.equals(actionName, that.actionName);
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(packageName);
        result = 31 * result + Objects.hashCode(actionName);
        return result;
    }

    @Override
    public String toString() {
        return "ActionCommand{" +
                "packageName='" + packageName + '\'' +
                ", actionName='" + actionName + '\'' +
                '}';
    }
}
