package rocks.imsofa.sjl;

import java.util.UUID;

/**
 * a request to execute an action
 * the request is sent to the server
 * the server will redirect the request to the app that supports the action
 */

public class ActionRequest {
    private ActionCommand actionCommand;
    private String argsJson;
    private boolean requireResponse;
    private String id= UUID.randomUUID().toString();
    int sourcePort;

    public ActionRequest(ActionCommand actionCommand, String argsJson, boolean requireResponse, int sourcePort) {
        this.actionCommand=actionCommand;
        this.argsJson = argsJson;
        this.requireResponse = requireResponse;
        this.sourcePort=sourcePort;
    }

    public ActionRequest() {
    }

    public int getSourcePort() {
        return sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public String getId() {
        return id;
    }

    public boolean isRequireResponse() {
        return requireResponse;
    }

    public void setRequireResponse(boolean requireResponse) {
        this.requireResponse = requireResponse;
    }

    public ActionCommand getActionCommand() {
        return actionCommand;
    }

    public void setActionCommand(ActionCommand actionCommand) {
        this.actionCommand = actionCommand;
    }

    public String getArgsJson() {
        return argsJson;
    }

    public void setArgsJson(String argsJson) {
        this.argsJson = argsJson;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;

        ActionRequest that = (ActionRequest) o;
        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}
