package rocks.imsofa.sjl;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.logging.Logger;

public class Main3 {
    public static void main(String[] args) throws Exception{
        EventLoopGroup bossGroup=null;
        ChannelFuture f;
        EventLoopGroup workerGroup;
        try {
            bossGroup = new NioEventLoopGroup(); // (1)
            workerGroup = new NioEventLoopGroup();
            ServerBootstrap b = new ServerBootstrap();
            b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)
                    .childHandler(new ChannelInitializer<SocketChannel>() { // (4)
                        @Override
                        public void initChannel(SocketChannel ch) throws Exception {
                            ch.pipeline().addLast(new StringDecoder());
                            ch.pipeline().addLast(new StringEncoder());
                            ch.pipeline().addLast(new SimpleChannelInboundHandler<String>() {
                                @Override
                                protected void channelRead0(ChannelHandlerContext ctx, String str) throws Exception {
                                    System.out.println("str="+str);
                                }
                            });

                        }
                    });

            f = b.bind(0).sync();
            //this is the port in use
            int port=((InetSocketAddress) f.channel().localAddress()).getPort();
            Thread.sleep(10000);
            System.out.println("shuttind down");
            bossGroup.shutdownGracefully();
            System.out.println("bossGroup shutdown");
            workerGroup.shutdownGracefully();
            System.out.println("workerGroup shutdown");
            f.channel().closeFuture().sync();
            System.out.println("closed");
        } catch (Exception e) {
            throw e;
        }
    }
}
