package rocks.imsofa.sjl;

/**
 * a RemotePacket is a message forwarded from the server to this app
 * can either be an action response or an action request
 */
public class RemotePacket {
    public static final int ACTION_RESPONSE=0;
    public static final int ACTION_REQUEST=1;
    private int type;
    private ActionRequest actionRequest;
    private ActionResponse actionResponse;

    public RemotePacket(ActionRequest actionRequest) {
        this.type = ACTION_REQUEST;
        this.actionRequest = actionRequest;
    }

    public RemotePacket(ActionResponse actionResponse) {
        this.type = ACTION_RESPONSE;
        this.actionResponse = actionResponse;
    }

    public RemotePacket() {
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ActionRequest getActionRequest() {
        return actionRequest;
    }

    public void setActionRequest(ActionRequest actionRequest) {
        this.actionRequest = actionRequest;
    }

    public ActionResponse getActionResponse() {
        return actionResponse;
    }

    public void setActionResponse(ActionResponse actionResponse) {
        this.actionResponse = actionResponse;
    }
}
