package rocks.imsofa.sjl;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import rocks.imsofa.sjl.simple.SimpleClientCallback;

/**
 * a simple client that only handles string output
 */
public class SimpleClient {
    public void send(String host, int port, String json, SimpleClientCallback callback){
        EventLoopGroup workerGroup = new NioEventLoopGroup();
        ChannelFuture f=null;
        try {
            Bootstrap b = new Bootstrap(); // (1)
            b.group(workerGroup); // (2)
            b.channel(NioSocketChannel.class); // (3)
            b.option(ChannelOption.SO_KEEPALIVE, true); // (4)
            b.handler(new ChannelInitializer<SocketChannel>() {
                @Override
                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new StringDecoder());
                    ch.pipeline().addLast(new StringEncoder());
                    ch.pipeline().addLast(new SimpleChannelInboundHandler<String>() {
                        @Override
                        protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
                            callback.onResponse(msg);
                            ctx.close();
                        }
                    });
                }
            });

            // Start the client.
            f = b.connect(host, port).sync(); // (5)
            f.channel().writeAndFlush(Unpooled.copiedBuffer(json, CharsetUtil.UTF_8));
            f. channel().read(); // Wait until the connection is closed.
            // Wait until the connection is closed.
            f.channel().closeFuture().sync();
        } catch (InterruptedException e) {
            callback.onError(e);
        } finally {
            workerGroup.shutdownGracefully();
        }
    }
}
