package rocks.imsofa.sjl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import rocks.imsofa.sjl.simple.HandlerContext;
import rocks.imsofa.sjl.simple.SimpleServerCallback;

import java.net.InetSocketAddress;

/**
 * a simple server that only handles string input and output
 */
public class SimpleServer {
    private final EventLoopGroup bossGroup;
    private final ChannelFuture f;
    private final EventLoopGroup workerGroup;
    private final int port;

    /**
     * start the server on a randomly assigned port
     * @param callback
     * @throws InterruptedException
     */
    public SimpleServer(SimpleServerCallback callback) throws InterruptedException {
        this(0, callback);
    }

    /**
     * start the server on the given port
     * @param port
     * @param callback
     * @throws InterruptedException
     */
    public SimpleServer(int port, SimpleServerCallback callback) throws InterruptedException {
        bossGroup = new NioEventLoopGroup(); // (1)
        workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)
                .childHandler(new ChannelInitializer<SocketChannel>() { // (4)
                    @Override
                    public void initChannel(SocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new StringDecoder());
                        ch.pipeline().addLast(new StringEncoder());
                        ch.pipeline().addLast(new SimpleChannelInboundHandler<String>() {
                            @Override
                            protected void channelRead0(ChannelHandlerContext ctx, String str) throws Exception {
                                callback.onReceive(str, new HandlerContext(ctx));
                            }
                        });

                    }
                });

        f = b.bind(port).sync();
        //this is the port in use
        this.port = ((InetSocketAddress) f.channel().localAddress()).getPort();
    }

    /**
     *
     * @return the real port used to run the server
     */
    public int getPort() {
        return port;
    }

    /**
     * shutdown the server gracefully
     * @throws InterruptedException
     */
    public void shutdown() throws InterruptedException {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
        f.channel().closeFuture().sync();
    }
}
