/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.sjl;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import rocks.imsofa.sjl.ActionCallback;
import rocks.imsofa.sjl.ActionCommand;
import rocks.imsofa.sjl.ActionCommandRegistrationRequest;
import rocks.imsofa.sjl.ActionRequest;
import rocks.imsofa.sjl.ActionResponse;
import rocks.imsofa.sjl.ActionResultCallback;
import rocks.imsofa.sjl.RemotePacket;
import rocks.imsofa.sjl.SimpleServer;

public class Messenger {
    private static Messenger instance = null;
    private static boolean initialized = false;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Map<ActionRequest, ActionResultCallback> pendingRequests = new HashMap<ActionRequest, ActionResultCallback>();
    private Map<ActionCommand, ActionCallback> actionCommandToCallbackMap = new HashMap<ActionCommand, ActionCallback>();
    private SimpleServer simpleServer = null;

    public synchronized void init(List<ActionCommand> providedActions) throws Exception {
        this.init(providedActions, 0);
    }

    public synchronized void init(List<ActionCommand> providedActions, int serverPort) throws Exception {
        if (initialized) {
            return;
        }
        this.simpleServer = new SimpleServer(serverPort, (str, ctx) -> {
            Gson gson = new Gson();
            RemotePacket packet = (RemotePacket)gson.fromJson(str, RemotePacket.class);
            if (packet.getType() == 0) {
                ActionResponse response = packet.getActionResponse();
                ActionRequest request = response.getSourceRequest();
                ActionResultCallback callback = this.pendingRequests.get(request);
                System.out.println("callback=" + String.valueOf(callback));
                if (callback != null) {
                    callback.onResult(request, response);
                    this.pendingRequests.remove(request);
                }
                ctx.close();
            } else if (packet.getType() == 1) {
                ActionRequest request = packet.getActionRequest();
                Logger.getLogger(this.getClass().getName()).info("action request received for " + String.valueOf(request.getActionCommand()));
                ActionCallback callback = this.actionCommandToCallbackMap.get(request.getActionCommand());
                ActionResponse actionResponse = null;
                if (callback != null) {
                    String response = callback.onExecute(request);
                    actionResponse = new ActionResponse(request, response, false);
                } else {
                    actionResponse = new ActionResponse(request, "{'message':'not supported'}", true);
                }
                String json = gson.toJson((Object)actionResponse);
                ctx.writeAndFlush(json);
                Logger.getLogger(this.getClass().getName()).info("response for action " + String.valueOf(request.getActionCommand()) + " is written " + json);
                ctx.close();
            }
        });
        int port = this.simpleServer.getPort();
        ActionCommandRegistrationRequest request = new ActionCommandRegistrationRequest();
        request.setPort(port);
        request.setActionCommands(providedActions);
        Gson gson = new Gson();
        String json = gson.toJson((Object)request);
        boolean ok = HttpRequest.post((CharSequence)"http://localhost:8221/registerActionCommands").contentType("application/json").send((CharSequence)json).ok();
        if (!ok) {
            this.simpleServer.shutdown();
            throw new Exception("unable to register action commands");
        }
        initialized = true;
    }

    public void execute(ActionRequest request, ActionResultCallback callback) throws Exception {
        if (!initialized) {
            throw new Exception("messenger not initialized");
        }
        request.setSourcePort(this.simpleServer.getPort());
        this.executorService.submit(() -> {
            Gson gson = new Gson();
            this.pendingRequests.put(request, callback);
            String json = gson.toJson((Object)request);
            boolean ok = HttpRequest.post((CharSequence)"http://localhost:8221/executeActionCommand").contentType("application/json").send((CharSequence)json).ok();
            if (!ok) {
                this.pendingRequests.remove(request);
                callback.onError(request);
            }
        });
    }

    public void registerActionCallback(ActionCommand actionCommand, ActionCallback callback) {
        this.actionCommandToCallbackMap.put(actionCommand, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Messenger getInstance() {
        Class<Messenger> clazz = Messenger.class;
        synchronized (Messenger.class) {
            if (instance == null) {
                instance = new Messenger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getPort() {
        return this.simpleServer.getPort();
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            this.simpleServer.shutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        Messenger.getInstance().init(List.of(new ActionCommand("test", "test1")), 8001);
        Messenger.getInstance().registerActionCallback(new ActionCommand("test", "test1"), new ActionCallback(){

            @Override
            public String onExecute(ActionRequest request) {
                System.out.println("action executed");
                return "hello";
            }
        });
    }
}

