/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.sjl;

import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import rocks.imsofa.sjl.ActionCallback;
import rocks.imsofa.sjl.ActionCommand;
import rocks.imsofa.sjl.ActionCommandRegistrationRequest;
import rocks.imsofa.sjl.ActionRequest;
import rocks.imsofa.sjl.ActionResponse;
import rocks.imsofa.sjl.ActionResultCallback;
import rocks.imsofa.sjl.RemotePacket;

public class Messenger2 {
    private static Messenger2 instance = null;
    private static boolean initialized = false;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Map<ActionRequest, ActionResultCallback> pendingRequests = new HashMap<ActionRequest, ActionResultCallback>();
    private Map<ActionCommand, ActionCallback> actionCommandToCallbackMap = new HashMap<ActionCommand, ActionCallback>();
    private int port = -1;
    private EventLoopGroup bossGroup;
    private ChannelFuture f;
    private EventLoopGroup workerGroup;

    public synchronized void init(List<ActionCommand> providedActions) throws Exception {
        this.init(providedActions, 0);
    }

    public synchronized void init(List<ActionCommand> providedActions, int serverPort) throws Exception {
        if (initialized) {
            return;
        }
        this.bossGroup = null;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<String>(){

                    protected void channelRead0(ChannelHandlerContext ctx, String str) throws Exception {
                        System.out.println("str=" + str);
                        Gson gson = new Gson();
                        RemotePacket packet = (RemotePacket)gson.fromJson(str, RemotePacket.class);
                        if (packet.getType() == 0) {
                            ActionResponse response = packet.getActionResponse();
                            ActionRequest request = response.getSourceRequest();
                            ActionResultCallback callback = Messenger2.this.pendingRequests.get(request);
                            System.out.println("callback=" + String.valueOf(callback));
                            if (callback != null) {
                                callback.onResult(request, response);
                                Messenger2.this.pendingRequests.remove(request);
                            }
                            ctx.close();
                        } else if (packet.getType() == 1) {
                            ActionRequest request = packet.getActionRequest();
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("action request received for " + String.valueOf(request.getActionCommand()));
                            ActionCallback callback = Messenger2.this.actionCommandToCallbackMap.get(request.getActionCommand());
                            ActionResponse actionResponse = null;
                            if (callback != null) {
                                String response = callback.onExecute(request);
                                actionResponse = new ActionResponse(request, response, false);
                            } else {
                                actionResponse = new ActionResponse(request, "{'message':'not supported'}", true);
                            }
                            String json = gson.toJson((Object)actionResponse);
                            ctx.writeAndFlush((Object)json);
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("response for action " + String.valueOf(request.getActionCommand()) + " is written " + json);
                            ctx.close();
                        }
                    }
                }});
            }
        });
        this.f = b.bind(serverPort).sync();
        this.port = ((InetSocketAddress)this.f.channel().localAddress()).getPort();
        ActionCommandRegistrationRequest request = new ActionCommandRegistrationRequest();
        request.setPort(this.port);
        request.setActionCommands(providedActions);
        Gson gson = new Gson();
        String json = gson.toJson((Object)request);
        boolean ok = HttpRequest.post((CharSequence)"http://localhost:8221/registerActionCommands").contentType("application/json").send((CharSequence)json).ok();
        if (!ok) {
            this.f.channel().close();
            throw new Exception("unable to register action commands");
        }
        initialized = true;
    }

    public void execute(ActionRequest request, ActionResultCallback callback) throws Exception {
        if (!initialized) {
            throw new Exception("messenger not initialized");
        }
        request.setSourcePort(this.port);
        this.executorService.submit(() -> {
            Gson gson = new Gson();
            this.pendingRequests.put(request, callback);
            String json = gson.toJson((Object)request);
            boolean ok = HttpRequest.post((CharSequence)"http://localhost:8221/executeActionCommand").contentType("application/json").send((CharSequence)json).ok();
            if (!ok) {
                this.pendingRequests.remove(request);
                callback.onError(request);
            }
        });
    }

    public void registerActionCallback(ActionCommand actionCommand, ActionCallback callback) {
        this.actionCommandToCallbackMap.put(actionCommand, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Messenger2 getInstance() {
        Class<Messenger2> clazz = Messenger2.class;
        synchronized (Messenger2.class) {
            if (instance == null) {
                instance = new Messenger2();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        Messenger2.getInstance().init(List.of(new ActionCommand("test", "test1")), 8001);
        Messenger2.getInstance().registerActionCallback(new ActionCommand("test", "test1"), (ActionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

