/*
 * Decompiled with CFR 0.152.
 */
package rocks.imsofa.sjl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.net.InetSocketAddress;
import rocks.imsofa.sjl.simple.HandlerContext;
import rocks.imsofa.sjl.simple.SimpleServerCallback;

public class SimpleServer {
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final ChannelFuture f;
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final int port;

    public SimpleServer(SimpleServerCallback callback) throws InterruptedException {
        this(0, callback);
    }

    public SimpleServer(int port, final SimpleServerCallback callback) throws InterruptedException {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<String>(){

                    protected void channelRead0(ChannelHandlerContext ctx, String str) throws Exception {
                        callback.onReceive(str, new HandlerContext(ctx));
                    }
                }});
            }
        });
        this.f = b.bind(port).sync();
        this.port = ((InetSocketAddress)this.f.channel().localAddress()).getPort();
    }

    public int getPort() {
        return this.port;
    }

    public void shutdown() throws InterruptedException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.f.channel().closeFuture().sync();
    }
}

