/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.internal.util;

import java.lang.reflect.Method;
import java.util.Random;
import rocks.inspectit.agent.java.sdk.opentracing.internal.TracerLogger;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.TracerLoggerWrapper;

public final class RandomUtils {
    private static final TracerLogger LOGGER;
    private static final Random RANDOM;
    private static Method threadLocalRandomCurrentMethod;

    private RandomUtils() {
    }

    public static long randomLong() {
        byte[] randomBytes = new byte[8];
        RandomUtils.getRandom().nextBytes(randomBytes);
        return ((long)randomBytes[0] & 0xFFL) << 56 | ((long)randomBytes[1] & 0xFFL) << 48 | ((long)randomBytes[2] & 0xFFL) << 40 | ((long)randomBytes[3] & 0xFFL) << 32 | ((long)randomBytes[4] & 0xFFL) << 24 | ((long)randomBytes[5] & 0xFFL) << 16 | ((long)randomBytes[6] & 0xFFL) << 8 | (long)randomBytes[7] & 0xFFL;
    }

    private static Random getRandom() {
        if (null != threadLocalRandomCurrentMethod) {
            try {
                return (Random)threadLocalRandomCurrentMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Error invoking the current() method on the ThreadLocalRandom");
                }
                return RANDOM;
            }
        }
        return RANDOM;
    }

    static {
        block2: {
            LOGGER = TracerLoggerWrapper.getTraceLogger(RandomUtils.class);
            RANDOM = new Random();
            try {
                Class<?> clazz = Class.forName("java.util.concurrent.ThreadLocalRandom");
                threadLocalRandomCurrentMethod = clazz.getDeclaredMethod("current", new Class[0]);
                threadLocalRandomCurrentMethod.setAccessible(true);
            }
            catch (Exception e) {
                if (!LOGGER.isInfoEnabled()) break block2;
                LOGGER.info("ThreadLocalRandom is not available. Using " + RANDOM.getClass().getSimpleName() + " for generating random numbers.");
            }
        }
    }
}

