/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.propagation;

import java.util.HashMap;
import java.util.Map;
import rocks.inspectit.agent.java.sdk.opentracing.internal.TracerLogger;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanContextImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.TracerLoggerWrapper;
import rocks.inspectit.agent.java.sdk.opentracing.internal.util.ConversionUtils;
import rocks.inspectit.agent.java.sdk.opentracing.propagation.Propagator;

public abstract class AbstractPropagator<C>
implements Propagator<C> {
    private static final TracerLogger LOGGER = TracerLoggerWrapper.getTraceLogger(AbstractPropagator.class);

    protected abstract void injectBaggage(C var1, String var2, String var3);

    protected abstract Iterable<Map.Entry<String, String>> extractBaggage(C var1);

    @Override
    public void inject(SpanContextImpl spanContext, C carrier) {
        if (null == spanContext) {
            return;
        }
        this.injectBaggage(carrier, "inspectit_spanid", ConversionUtils.toHexString(spanContext.getId()));
        this.injectBaggage(carrier, "inspectit_traceid", ConversionUtils.toHexString(spanContext.getTraceId()));
        Iterable<Map.Entry<String, String>> baggageItems = spanContext.baggageItems();
        if (null != baggageItems) {
            for (Map.Entry<String, String> e : baggageItems) {
                this.injectBaggage(carrier, "inspectit_baggage_" + e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public SpanContextImpl extract(C carrier) {
        Iterable<Map.Entry<String, String>> iterable = this.extractBaggage(carrier);
        if (null == iterable || null == iterable.iterator()) {
            return null;
        }
        HashMap<String, String> passedBaggage = new HashMap<String, String>();
        String idFromBaggage = null;
        String traceIdFromBaggage = null;
        for (Map.Entry<String, String> e : iterable) {
            String key = e.getKey();
            if ("inspectit_spanid".equals(key)) {
                idFromBaggage = e.getValue();
                continue;
            }
            if ("inspectit_traceid".equals(key)) {
                traceIdFromBaggage = e.getValue();
                continue;
            }
            if (!key.startsWith("inspectit_baggage_")) continue;
            String realKey = key.substring("inspectit_baggage_".length());
            passedBaggage.put(realKey, e.getValue());
        }
        if (this.notEmpty(idFromBaggage) && this.notEmpty(traceIdFromBaggage)) {
            try {
                long id = ConversionUtils.parseHexStringSafe(idFromBaggage);
                long traceId = ConversionUtils.parseHexStringSafe(traceIdFromBaggage);
                return SpanContextImpl.buildExtractedContext(id, traceId, passedBaggage);
            }
            catch (NumberFormatException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Failed converting span and trace id. These are expected in the hexadecimal format, but were " + idFromBaggage + " and " + traceIdFromBaggage + ".", e);
                }
                return null;
            }
        }
        return null;
    }

    private boolean notEmpty(String s) {
        return null != s && !s.isEmpty();
    }
}

