/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.internal.impl;

import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import rocks.inspectit.agent.java.sdk.opentracing.ExtendedTracer;
import rocks.inspectit.agent.java.sdk.opentracing.Reporter;
import rocks.inspectit.agent.java.sdk.opentracing.Timer;
import rocks.inspectit.agent.java.sdk.opentracing.TracerProvider;
import rocks.inspectit.agent.java.sdk.opentracing.internal.TracerLogger;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanBuilderImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanContextImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.TracerLoggerWrapper;
import rocks.inspectit.agent.java.sdk.opentracing.internal.propagation.TextMapPropagator;
import rocks.inspectit.agent.java.sdk.opentracing.internal.propagation.UrlEncodingPropagator;
import rocks.inspectit.agent.java.sdk.opentracing.noop.NoopReporter;
import rocks.inspectit.agent.java.sdk.opentracing.propagation.Propagator;
import rocks.inspectit.agent.java.sdk.opentracing.util.SystemTimer;

public class TracerImpl
implements ExtendedTracer {
    private static final TracerLogger LOGGER = TracerLoggerWrapper.getTraceLogger(TracerImpl.class);
    private final ThreadLocal<Stack<SpanImpl>> spanStack = new ThreadLocal<Stack<SpanImpl>>(){

        @Override
        protected Stack<SpanImpl> initialValue() {
            return new Stack<SpanImpl>();
        }
    };
    private Timer timer;
    private final Reporter reporter;
    private final Map<Format<?>, Propagator<?>> propagators = new ConcurrentHashMap(4, 1.0f);

    public TracerImpl() {
        this(new SystemTimer(), new NoopReporter(), false);
    }

    public TracerImpl(Timer timer, Reporter reporter, boolean setToTracerProvider) {
        if (null == timer) {
            throw new IllegalArgumentException("Timer can not be null.");
        }
        if (null == reporter) {
            throw new IllegalArgumentException("Reporter can not be null.");
        }
        this.timer = timer;
        this.reporter = reporter;
        this.registerDefaultPropagators();
        if (setToTracerProvider) {
            TracerProvider.set(this);
        }
    }

    private void registerDefaultPropagators() {
        this.registerPropagator(Format.Builtin.TEXT_MAP, new TextMapPropagator());
        this.registerPropagator(Format.Builtin.HTTP_HEADERS, new UrlEncodingPropagator());
    }

    @Override
    public <C> void registerPropagator(Format<C> format, Propagator<C> propagator) {
        this.propagators.put(format, propagator);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("New propagator registered for the format" + format.toString() + ".");
        }
    }

    @Override
    public SpanBuilderImpl buildSpan() {
        return this.buildSpan(null);
    }

    public SpanBuilderImpl buildSpan(String operationName) {
        return this.buildSpan(operationName, "child_of", true);
    }

    @Override
    public SpanBuilderImpl buildSpan(String operationName, String referenceType, boolean useThreadContext) {
        SpanContextImpl threadContext;
        SpanBuilderImpl spanBuilder = new SpanBuilderImpl(this, operationName);
        if (useThreadContext && (threadContext = this.getCurrentContext()) != null) {
            spanBuilder.addReference(referenceType, threadContext);
        }
        return spanBuilder;
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (format == null || carrier == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Context can not be injected, both format and carrier must be provided.");
            }
            return;
        }
        if (spanContext instanceof SpanContextImpl) {
            Propagator<?> propagator = this.propagators.get(format);
            if (null != propagator) {
                propagator.inject((SpanContextImpl)spanContext, carrier);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Context can not be injected, propagator does not exists for the format " + format.toString() + ".");
            }
        }
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        if (format == null || carrier == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Context can not be extracted, both format and carrier must be provided.");
            }
            return null;
        }
        Propagator<?> propagator = this.propagators.get(format);
        if (null != propagator) {
            SpanContextImpl context = propagator.extract(carrier);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Context extracted: " + context);
            }
            return context;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Context can not be extracted, propagator does not exists for the format " + format.toString() + ".");
        }
        return null;
    }

    @Override
    public SpanContextImpl getCurrentContext() {
        Stack<SpanImpl> stack = this.spanStack.get();
        if (!stack.isEmpty()) {
            return stack.peek().context();
        }
        return null;
    }

    public boolean isCurrentContextExisting() {
        return !this.spanStack.get().isEmpty();
    }

    void spanStarted(SpanImpl span) {
        if (null == span) {
            return;
        }
        this.spanStack.get().push(span);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Span started " + span);
        }
    }

    void spanEnded(SpanImpl span) {
        if (null == span) {
            return;
        }
        Stack<SpanImpl> stack = this.spanStack.get();
        if (stack.contains(span)) {
            SpanImpl removed = stack.pop();
            boolean wrongEndOrder = false;
            while (!stack.isEmpty() && !removed.equals(span)) {
                wrongEndOrder = true;
                stack.pop();
            }
            if (wrongEndOrder && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Finishing of spans is not done in starting order, span " + span.toString() + " is not the last started one by current thread. Thread context state can be affected.");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Span finished " + span);
            }
        }
        if (span.isReport()) {
            this.reporter.report(span);
        }
    }

    Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTimer(Timer timer) {
        if (null == timer) {
            throw new IllegalArgumentException("Timer must not be null.");
        }
        this.timer = timer;
    }
}

