/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.internal.impl;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;
import rocks.inspectit.agent.java.sdk.opentracing.Timer;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanContextImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.TracerImpl;

public class SpanBuilderImpl
implements Tracer.SpanBuilder {
    private final SpanImpl span;
    private final Timer timer;
    private final Map<String, String> baggage = new HashMap<String, String>();
    private long startTimestamp;
    private SpanContextImpl parent;
    private String referenceType;

    public SpanBuilderImpl(TracerImpl tracer, String operationName) {
        this.timer = tracer.getTimer();
        this.span = new SpanImpl(tracer);
        this.span.setOperationName(operationName);
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public SpanBuilderImpl asChildOf(SpanContext parent) {
        if (null != parent) {
            this.addReference("child_of", parent);
        }
        return this;
    }

    public SpanBuilderImpl asChildOf(Span parent) {
        if (null != parent) {
            this.addReference("child_of", parent.context());
        }
        return this;
    }

    public SpanBuilderImpl addReference(String referenceType, SpanContext referencedContext) {
        if (null != referencedContext) {
            if (("child_of".equals(referenceType) || "follows_from".equals(referenceType)) && null == this.parent && referencedContext instanceof SpanContextImpl) {
                this.parent = (SpanContextImpl)referencedContext;
                this.referenceType = referenceType;
            }
            this.withBaggageFrom(referencedContext);
        }
        return this;
    }

    public SpanBuilderImpl withTag(String key, String value) {
        this.span.setTag(key, value);
        return this;
    }

    public SpanBuilderImpl withTag(String key, boolean value) {
        this.span.setTag(key, value);
        return this;
    }

    public SpanBuilderImpl withTag(String key, Number value) {
        this.span.setTag(key, value);
        return this;
    }

    public SpanBuilderImpl withStartTimestamp(long microseconds) {
        this.startTimestamp = microseconds;
        return this;
    }

    public SpanBuilderImpl doNotReport() {
        this.span.setReport(false);
        return this;
    }

    private void withBaggageFrom(SpanContext from) {
        Iterable baggageItems = from.baggageItems();
        if (null == baggageItems || null == baggageItems.iterator()) {
            return;
        }
        for (Map.Entry baggageItem : baggageItems) {
            this.baggage.put((String)baggageItem.getKey(), (String)baggageItem.getValue());
        }
    }

    public SpanImpl start() {
        this.build();
        long nanoTime = 0L;
        if (this.startTimestamp <= 0L) {
            this.startTimestamp = this.timer.getCurrentTimeMicroseconds();
            nanoTime = this.timer.getCurrentNanoTime();
        }
        this.span.start(this.startTimestamp, nanoTime);
        return this.span;
    }

    public SpanImpl build() {
        SpanContextImpl context = SpanContextImpl.build(this.parent, this.referenceType, this.baggage);
        this.span.setSpanContext(context);
        return this.span;
    }
}

