/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.internal.impl;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.SpanContextImpl;
import rocks.inspectit.agent.java.sdk.opentracing.internal.impl.TracerImpl;

public class SpanImpl
implements Span {
    private final TracerImpl tracer;
    private String operationName;
    private SpanContextImpl spanContext;
    private long startTimeMicros;
    private long startTimeNanos;
    private double duration;
    private boolean report = true;
    private Map<String, String> tags;
    private boolean finished = false;

    public SpanImpl(TracerImpl tracer) {
        this.tracer = tracer;
    }

    public SpanContextImpl context() {
        return this.spanContext;
    }

    public void start() {
        this.start(this.tracer.getTimer().getCurrentTimeMicroseconds(), this.tracer.getTimer().getCurrentNanoTime());
    }

    void start(long startTimeMicros, long startTimeNanos) {
        if (this.isStarted()) {
            return;
        }
        if (startTimeMicros <= 0L) {
            throw new IllegalArgumentException("Start time in microseconds must be provided.");
        }
        this.startTimeMicros = startTimeMicros;
        this.startTimeNanos = startTimeNanos;
        this.tracer.spanStarted(this);
    }

    public void finish() {
        if (this.startTimeNanos != 0L) {
            this.finishWithNanos(this.tracer.getTimer().getCurrentNanoTime());
        } else {
            this.finish(this.tracer.getTimer().getCurrentTimeMicroseconds());
        }
    }

    public void finish(long finishMicros) {
        if (this.isFinished()) {
            return;
        }
        if (this.isStarted()) {
            this.duration = finishMicros - this.startTimeMicros;
        }
        this.finished = true;
        this.tracer.spanEnded(this);
    }

    private void finishWithNanos(long nanos) {
        if (this.isFinished()) {
            return;
        }
        this.duration = (double)(nanos - this.startTimeNanos) / 1000.0;
        this.finished = true;
        this.tracer.spanEnded(this);
    }

    public void close() {
        this.finish();
    }

    public Span setTag(String key, String value) {
        return this.setTagInternal(key, value);
    }

    public Span setTag(String key, boolean value) {
        return this.setTagInternal(key, String.valueOf(value));
    }

    public Span setTag(String key, Number value) {
        return this.setTagInternal(key, value.toString());
    }

    private Span setTagInternal(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>(1, 1.0f);
        }
        this.tags.put(key, value);
        return this;
    }

    public Span log(Map<String, ?> fields) {
        return this;
    }

    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        return this;
    }

    public Span log(String event) {
        return this;
    }

    public Span log(long timestampMicroseconds, String event) {
        return this;
    }

    @Deprecated
    public Span log(String eventName, Object payload) {
        return this;
    }

    @Deprecated
    public Span log(long timestampMicroseconds, String eventName, Object payload) {
        return this;
    }

    public Span setBaggageItem(String key, String value) {
        if (null != this.spanContext) {
            this.spanContext.setBaggageItem(key, value);
        }
        return this;
    }

    public String getBaggageItem(String key) {
        if (null != this.spanContext) {
            return this.spanContext.getBaggageItem(key);
        }
        return null;
    }

    public boolean isClient() {
        if (this.tags != null) {
            String kind = this.tags.get(Tags.SPAN_KIND.getKey());
            return "client".equals(kind);
        }
        return false;
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public boolean isStarted() {
        return this.startTimeMicros > 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public long getStartTimeMicros() {
        return this.startTimeMicros;
    }

    public double getDuration() {
        return this.duration;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setSpanContext(SpanContextImpl spanContext) {
        this.spanContext = spanContext;
    }

    public boolean isReport() {
        return this.report;
    }

    void setReport(boolean report) {
        this.report = report;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.spanContext == null ? 0 : this.spanContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanImpl other = (SpanImpl)obj;
        return !(this.spanContext == null ? other.spanContext != null : !this.spanContext.equals(other.spanContext));
    }

    public String toString() {
        return "SpanImpl [spanContext=" + this.spanContext + ", operationName=" + this.operationName + ", duration=" + this.duration + ", report=" + this.report + ", tags=" + this.tags + "]";
    }
}

