/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.internal.impl;

import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import rocks.inspectit.agent.java.sdk.opentracing.internal.util.RandomUtils;

public class SpanContextImpl
implements SpanContext {
    private final long id;
    private final long traceId;
    private final long parentId;
    private final String referenceType;
    private final Map<String, String> baggage;

    public SpanContextImpl(long id, long traceId, long parentId, String referenceType, Map<String, String> baggage) {
        this.id = id;
        this.traceId = traceId;
        this.parentId = parentId;
        this.referenceType = referenceType;
        this.baggage = null != baggage && !baggage.isEmpty() ? new HashMap<String, String>(baggage) : new HashMap<String, String>(0, 1.0f);
    }

    public static SpanContextImpl build(SpanContextImpl parent, String referenceType, Map<String, String> baggage) {
        if (null == parent) {
            return SpanContextImpl.build(baggage);
        }
        long id = RandomUtils.randomLong();
        SpanContextImpl spanContextImpl = new SpanContextImpl(id, parent.getTraceId(), parent.getId(), referenceType, baggage);
        return spanContextImpl;
    }

    public static SpanContextImpl build(Map<String, String> baggage) {
        long id = RandomUtils.randomLong();
        return new SpanContextImpl(id, id, id, null, baggage);
    }

    public static SpanContextImpl build() {
        long id = RandomUtils.randomLong();
        return new SpanContextImpl(id, id, id, null, null);
    }

    public static SpanContextImpl buildExtractedContext(long passedId, long passedTraceId, Map<String, String> passedBaggage) {
        return new SpanContextImpl(passedId, passedTraceId, passedId, null, passedBaggage);
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return Collections.unmodifiableMap(this.baggage).entrySet();
    }

    public void setBaggageItem(String key, String value) {
        this.baggage.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public long getId() {
        return this.id;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baggage == null ? 0 : this.baggage.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        result = 31 * result + (this.referenceType == null ? 0 : this.referenceType.hashCode());
        result = 31 * result + (int)(this.traceId ^ this.traceId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpanContextImpl other = (SpanContextImpl)obj;
        if (this.baggage == null ? other.baggage != null : !this.baggage.equals(other.baggage)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.parentId != other.parentId) {
            return false;
        }
        if (this.referenceType == null ? other.referenceType != null : !this.referenceType.equals(other.referenceType)) {
            return false;
        }
        return this.traceId == other.traceId;
    }

    public String toString() {
        return "SpanContextImpl [id=" + this.id + ", traceId=" + this.traceId + ", parentId=" + this.parentId + ", referenceType=" + this.referenceType + ", baggage=" + this.baggage + "]";
    }
}

