/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.agent.java.sdk.opentracing.internal.propagation;

import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import rocks.inspectit.agent.java.sdk.opentracing.propagation.AbstractPropagator;

public class UrlEncodingPropagator
extends AbstractPropagator<TextMap> {
    private static final String UTF_8 = "UTF-8";

    @Override
    protected void injectBaggage(TextMap carrier, String key, String value) {
        try {
            carrier.put(key, URLEncoder.encode(value, UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            carrier.put(key, value);
        }
    }

    @Override
    protected Iterable<Map.Entry<String, String>> extractBaggage(TextMap carrier) {
        if (null == carrier || null == carrier.iterator()) {
            return null;
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : carrier) {
            try {
                map.put(entry.getKey(), URLDecoder.decode((String)entry.getValue(), UTF_8));
            }
            catch (UnsupportedEncodingException e) {
                map.put(entry.getKey(), (String)entry.getValue());
            }
        }
        return map.entrySet();
    }
}

