/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.opencensus.influx;

import java.util.HashMap;
import java.util.Map;

public class StatisticsCache {
    private Map<CacheKey, Number> valueMap = new HashMap<CacheKey, Number>();

    public Number getDifference(String measurementName, String fieldName, Map<String, String> tags, Number value) {
        CacheKey cacheKey = this.createCacheKey(measurementName, fieldName, tags);
        Number latestValue = this.valueMap.put(cacheKey, value);
        if (latestValue == null) {
            latestValue = 0L;
        }
        Number difference = value instanceof Long ? (Number)(value.longValue() - latestValue.longValue()) : (Number)(value.doubleValue() - latestValue.doubleValue());
        return difference;
    }

    private CacheKey createCacheKey(String measurementName, String fieldName, Map<String, String> tags) {
        return new CacheKey(measurementName, fieldName, new HashMap<String, String>(tags));
    }

    private static final class CacheKey {
        private final String measurementName;
        private final String fieldName;
        private final Map<String, String> tag;

        public CacheKey(String measurementName, String fieldName, Map<String, String> tag) {
            this.measurementName = measurementName;
            this.fieldName = fieldName;
            this.tag = tag;
        }

        public String getMeasurementName() {
            return this.measurementName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Map<String, String> getTag() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            String this$measurementName = this.getMeasurementName();
            String other$measurementName = other.getMeasurementName();
            if (this$measurementName == null ? other$measurementName != null : !this$measurementName.equals(other$measurementName)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            Map<String, String> this$tag = this.getTag();
            Map<String, String> other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $measurementName = this.getMeasurementName();
            result = result * 59 + ($measurementName == null ? 43 : $measurementName.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            Map<String, String> $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
            return result;
        }

        public String toString() {
            return "StatisticsCache.CacheKey(measurementName=" + this.getMeasurementName() + ", fieldName=" + this.getFieldName() + ", tag=" + this.getTag() + ")";
        }
    }
}

