/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.opencensus.influx;

import io.opencensus.common.Timestamp;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.stats.View;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InfluxUtils {
    private InfluxUtils() {
    }

    public static String getRawMeasurementName(String metricName, View view) {
        if (view == null) {
            return metricName;
        }
        return view.getMeasure().getName();
    }

    public static String getRawFieldName(MetricDescriptor.Type metricType, String rawMetricName, String rawMeasurementName) {
        String fieldName = InfluxUtils.removeCommonPrefix(rawMetricName, rawMeasurementName);
        String sanitizedFieldName = InfluxUtils.sanitizeName(fieldName);
        if (sanitizedFieldName.isEmpty()) {
            return InfluxUtils.getDefaultFieldName(metricType);
        }
        return fieldName;
    }

    public static Map<String, String> createTagMaps(List<LabelKey> labelKeys, List<LabelValue> labelValues) {
        Iterator<LabelKey> keys = labelKeys.iterator();
        Iterator<LabelValue> values = labelValues.iterator();
        HashMap<String, String> result = new HashMap<String, String>();
        while (keys.hasNext() && values.hasNext()) {
            String value = values.next().getValue();
            String key = keys.next().getKey();
            if (value == null || key == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static long getTimestampOfPoint(Point point) {
        Timestamp timestamp = point.getTimestamp();
        return (long)(timestamp.getNanos() / 1000 / 1000) + timestamp.getSeconds() * 1000L;
    }

    static String sanitizeName(String name) {
        return name.replaceAll("^[^a-zA-Z0-9]+|[^a-zA-Z0-9]+$", "").replaceAll("[^a-zA-Z0-9]+", "_").toLowerCase();
    }

    private static String getDefaultFieldName(MetricDescriptor.Type metricType) {
        switch (metricType) {
            case CUMULATIVE_DOUBLE: 
            case CUMULATIVE_INT64: {
                return "counter";
            }
            case CUMULATIVE_DISTRIBUTION: {
                return "histogram";
            }
        }
        return "value";
    }

    private static String removeCommonPrefix(String str, String prefixStr) {
        int commonLen;
        int limit = Math.min(str.length(), prefixStr.length());
        for (commonLen = 0; commonLen < limit && str.charAt(commonLen) == prefixStr.charAt(commonLen); ++commonLen) {
        }
        return str.substring(commonLen);
    }
}

