/*
 * Decompiled with CFR 0.152.
 */
package rocks.kavin.reqwest4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import rocks.kavin.reqwest4j.Response;

public class ReqwestUtils {
    public static native void init(String var0);

    public static native CompletableFuture<Response> fetch(String var0, String var1, byte[] var2, Map<String, String> var3);

    static {
        File nativeFile;
        String native_folder;
        String extension;
        String arch = switch (System.getProperty("os.arch")) {
            case "aarch64" -> "aarch64";
            case "amd64" -> "x86_64";
            default -> throw new RuntimeException("Unsupported architecture");
        };
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            extension = ".dll";
            native_folder = "windows";
        } else if (os.contains("linux")) {
            extension = ".so";
            native_folder = "linux";
        } else {
            throw new RuntimeException("OS not supported");
        }
        try {
            nativeFile = File.createTempFile("libreqwest", extension);
            nativeFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassLoader cl = ReqwestUtils.class.getClassLoader();
        try (InputStream stream = cl.getResourceAsStream("META-INF/natives/" + native_folder + "/" + arch + "/libreqwest" + extension);
             FileOutputStream fileOutputStream = new FileOutputStream(nativeFile);){
            stream.transferTo(fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.load(nativeFile.getAbsolutePath());
    }
}

