/*
 * Decompiled with CFR 0.152.
 */
package rocks.prestodb.query.formatter;

import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import rocks.prestodb.query.formatter.StatementFormatter;

public final class ExpressionFormatter {
    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression, Optional<List<Expression>> parameters, int indent) {
        return (String)new Formatter(parameters).process((Node)expression, indent);
    }

    static String formatStringLiteral(String s) {
        return "'" + s.replace("'", "''") + "'";
    }

    static String formatSortItems(List<SortItem> sortItems, Optional<List<Expression>> parameters, int indent) {
        return Joiner.on((String)", ").join(sortItems.stream().map(ExpressionFormatter.sortItemFormatterFunction(parameters, indent)).iterator());
    }

    static String formatGroupBy(List<GroupingElement> groupingElements, int indent) {
        return ExpressionFormatter.formatGroupBy(groupingElements, Optional.empty(), indent);
    }

    static String formatGroupBy(List<GroupingElement> groupingElements, Optional<List<Expression>> parameters, int indent) {
        ImmutableList.Builder resultStrings = ImmutableList.builder();
        for (GroupingElement groupingElement : groupingElements) {
            String result = "";
            if (groupingElement instanceof SimpleGroupBy) {
                ImmutableSet columns = ImmutableSet.copyOf((Collection)((SimpleGroupBy)groupingElement).getColumnExpressions());
                result = columns.size() == 1 ? ExpressionFormatter.formatExpression((Expression)Iterables.getOnlyElement((Iterable)columns), parameters, indent) : ExpressionFormatter.formatGroupingSet((Set<Expression>)columns, parameters, indent);
            } else if (groupingElement instanceof GroupingSets) {
                result = String.format("GROUPING SETS (%s)", Joiner.on((String)", ").join(((GroupingSets)groupingElement).getSets().stream().map(ExpressionFormatter::formatGroupingSet).iterator()));
            } else if (groupingElement instanceof Cube) {
                result = String.format("CUBE %s", ExpressionFormatter.formatGroupingSet(((Cube)groupingElement).getColumns()));
            } else if (groupingElement instanceof Rollup) {
                result = String.format("ROLLUP %s", ExpressionFormatter.formatGroupingSet(((Rollup)groupingElement).getColumns()));
            }
            resultStrings.add((Object)result);
        }
        return Joiner.on((String)", ").join((Iterable)resultStrings.build());
    }

    private static String formatGroupingSet(List<QualifiedName> groupingSet) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet));
    }

    private static String formatGroupingSet(Set<Expression> groupingSet, Optional<List<Expression>> parameters, int indent) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet.stream().map(e -> ExpressionFormatter.formatExpression(e, parameters, indent)).iterator()));
    }

    private static Function<SortItem, String> sortItemFormatterFunction(Optional<List<Expression>> parameters, int indent) {
        return input -> {
            StringBuilder builder = new StringBuilder();
            builder.append(ExpressionFormatter.formatExpression(input.getSortKey(), parameters, indent));
            switch (input.getOrdering()) {
                case ASCENDING: {
                    builder.append(" ASC");
                    break;
                }
                case DESCENDING: {
                    builder.append(" DESC");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ordering: " + input.getOrdering());
                }
            }
            switch (input.getNullOrdering()) {
                case FIRST: {
                    builder.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    builder.append(" NULLS LAST");
                    break;
                }
                case UNDEFINED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown null ordering: " + input.getNullOrdering());
                }
            }
            return builder.toString();
        };
    }

    public static class Formatter
    extends AstVisitor<String, Integer> {
        private final Optional<List<Expression>> parameters;

        public Formatter(Optional<List<Expression>> parameters) {
            this.parameters = parameters;
        }

        protected String visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException();
        }

        protected String visitRow(Row node, Integer indent) {
            return "ROW (" + Joiner.on((String)", ").join((Iterable)node.getItems().stream().map(child -> (String)this.process((Node)child, indent)).collect(Collectors.toList())) + ")";
        }

        protected String visitExpression(Expression node, Integer indent) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", ((Object)((Object)this)).getClass().getName(), node.getClass().getSimpleName()));
        }

        protected String visitAtTimeZone(AtTimeZone node, Integer indent) {
            return (String)this.process((Node)node.getValue(), indent) + " AT TIME ZONE " + (String)this.process((Node)node.getTimeZone(), indent);
        }

        protected String visitCurrentTime(CurrentTime node, Integer indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().getName());
            if (node.getPrecision() != null) {
                builder.append('(').append(node.getPrecision()).append(')');
            }
            return builder.toString();
        }

        protected String visitExtract(Extract node, Integer indent) {
            return "EXTRACT(" + node.getField() + " FROM " + (String)this.process((Node)node.getExpression(), indent) + ")";
        }

        protected String visitBooleanLiteral(BooleanLiteral node, Integer indent) {
            return String.valueOf(node.getValue());
        }

        protected String visitStringLiteral(StringLiteral node, Integer indent) {
            return ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        protected String visitCharLiteral(CharLiteral node, Integer indent) {
            return "CHAR " + ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        protected String visitBinaryLiteral(BinaryLiteral node, Integer indent) {
            return "X'" + node.toHexString() + "'";
        }

        protected String visitParameter(Parameter node, Integer indent) {
            if (this.parameters.isPresent()) {
                Preconditions.checkArgument((node.getPosition() < this.parameters.get().size() ? 1 : 0) != 0, (String)"Invalid parameter number %s.  Max value is %s", (Object[])new Object[]{node.getPosition(), this.parameters.get().size() - 1});
                return (String)this.process((Node)this.parameters.get().get(node.getPosition()), indent);
            }
            return "?";
        }

        protected String visitArrayConstructor(ArrayConstructor node, Integer indent) {
            ImmutableList.Builder valueStrings = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                valueStrings.add((Object)ExpressionFormatter.formatExpression(value, this.parameters, indent + 1));
            }
            return "ARRAY[" + Joiner.on((String)",").join((Iterable)valueStrings.build()) + "]";
        }

        protected String visitSubscriptExpression(SubscriptExpression node, Integer indent) {
            return ExpressionFormatter.formatExpression(node.getBase(), this.parameters, indent) + "[" + ExpressionFormatter.formatExpression(node.getIndex(), this.parameters, indent) + "]";
        }

        protected String visitLongLiteral(LongLiteral node, Integer indent) {
            return Long.toString(node.getValue());
        }

        protected String visitDoubleLiteral(DoubleLiteral node, Integer indent) {
            return Double.toString(node.getValue());
        }

        protected String visitDecimalLiteral(DecimalLiteral node, Integer indent) {
            return "DECIMAL '" + node.getValue() + "'";
        }

        protected String visitGenericLiteral(GenericLiteral node, Integer indent) {
            return node.getType() + " " + ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        protected String visitTimeLiteral(TimeLiteral node, Integer indent) {
            return "TIME '" + node.getValue() + "'";
        }

        protected String visitTimestampLiteral(TimestampLiteral node, Integer indent) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        protected String visitNullLiteral(NullLiteral node, Integer indent) {
            return "null";
        }

        protected String visitIntervalLiteral(IntervalLiteral node, Integer indent) {
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "- " : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append(" '").append(node.getValue()).append("' ").append(node.getStartField());
            if (node.getEndField().isPresent()) {
                builder.append(" TO ").append(node.getEndField().get());
            }
            return builder.toString();
        }

        protected String visitSubqueryExpression(SubqueryExpression node, Integer indent) {
            return "(\n" + StatementFormatter.formatSql((Node)node.getQuery(), this.parameters, indent + 1) + StatementFormatter.indentString(indent) + ')';
        }

        protected String visitExists(ExistsPredicate node, Integer indent) {
            return "EXISTS (\n" + StatementFormatter.formatSql(node.getSubquery(), this.parameters, indent + 1) + StatementFormatter.indentString(indent) + ")";
        }

        protected String visitIdentifier(Identifier node, Integer context) {
            return Formatter.formatIdentifier(node.getName());
        }

        protected String visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, Integer indent) {
            return Formatter.formatIdentifier(node.getName());
        }

        protected String visitSymbolReference(SymbolReference node, Integer indent) {
            return Formatter.formatIdentifier(node.getName());
        }

        protected String visitDereferenceExpression(DereferenceExpression node, Integer indent) {
            String baseString = (String)this.process((Node)node.getBase(), indent);
            return baseString + "." + Formatter.formatIdentifier(node.getFieldName());
        }

        private static String formatQualifiedName(QualifiedName name) {
            ArrayList<String> parts = new ArrayList<String>();
            for (String part : name.getParts()) {
                parts.add(Formatter.formatIdentifier(part));
            }
            return Joiner.on((char)'.').join(parts);
        }

        public String visitFieldReference(FieldReference node, Integer indent) {
            return ":input(" + node.getFieldIndex() + ")";
        }

        protected String visitFunctionCall(FunctionCall node, Integer indent) {
            StringBuilder builder = new StringBuilder();
            String arguments = this.joinExpressions(node.getArguments(), indent);
            if (node.getArguments().isEmpty() && "count".equalsIgnoreCase(node.getName().getSuffix())) {
                arguments = "*";
            }
            if (node.isDistinct()) {
                arguments = "DISTINCT " + arguments;
            }
            builder.append(Formatter.formatQualifiedName(node.getName())).append('(').append(arguments).append(')');
            if (node.getFilter().isPresent()) {
                builder.append(" FILTER ").append(this.visitFilter((Expression)node.getFilter().get(), indent));
            }
            if (node.getWindow().isPresent()) {
                builder.append(" OVER ").append(this.visitWindow((Window)node.getWindow().get(), indent));
            }
            return builder.toString();
        }

        protected String visitLambdaExpression(LambdaExpression node, Integer indent) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            Joiner.on((String)", ").appendTo(builder, (Iterable)node.getArguments());
            builder.append(") -> ");
            builder.append((String)this.process((Node)node.getBody(), indent));
            return builder.toString();
        }

        protected String visitLogicalBinaryExpression(LogicalBinaryExpression node, Integer indent) {
            String left = node.getLeft() instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)node.getLeft()).getType() != node.getType() ? '(' + (String)this.process((Node)node.getLeft(), indent + 1) + ')' : (String)this.process((Node)node.getLeft(), indent);
            String right = node.getRight() instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)node.getRight()).getType() != node.getType() ? '(' + (String)this.process((Node)node.getRight(), indent + 1) + ')' : (String)this.process((Node)node.getRight(), indent);
            return left + '\n' + StatementFormatter.indentString(indent + 1) + node.getType().toString() + ' ' + right;
        }

        protected String visitNotExpression(NotExpression node, Integer indent) {
            return "(NOT " + (String)this.process((Node)node.getValue(), indent) + ")";
        }

        protected String visitComparisonExpression(ComparisonExpression node, Integer indent) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight(), indent);
        }

        protected String visitIsNullPredicate(IsNullPredicate node, Integer indent) {
            return "(" + (String)this.process((Node)node.getValue(), indent) + " IS NULL)";
        }

        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Integer indent) {
            return "(" + (String)this.process((Node)node.getValue(), indent) + " IS NOT NULL)";
        }

        protected String visitNullIfExpression(NullIfExpression node, Integer indent) {
            return "NULLIF(" + (String)this.process((Node)node.getFirst(), indent) + ", " + (String)this.process((Node)node.getSecond(), indent) + ')';
        }

        protected String visitIfExpression(IfExpression node, Integer indent) {
            StringBuilder builder = new StringBuilder();
            builder.append("IF(").append((String)this.process((Node)node.getCondition(), indent)).append(", ").append((String)this.process((Node)node.getTrueValue(), indent));
            if (node.getFalseValue().isPresent()) {
                builder.append(", ").append((String)this.process((Node)node.getFalseValue().get(), indent));
            }
            builder.append(")");
            return builder.toString();
        }

        protected String visitTryExpression(TryExpression node, Integer indent) {
            return "TRY(" + (String)this.process((Node)node.getInnerExpression(), indent) + ")";
        }

        protected String visitCoalesceExpression(CoalesceExpression node, Integer indent) {
            return "COALESCE(" + this.joinExpressions(node.getOperands(), indent) + ")";
        }

        protected String visitArithmeticUnary(ArithmeticUnaryExpression node, Integer indent) {
            String value = (String)this.process((Node)node.getValue(), indent);
            switch (node.getSign()) {
                case MINUS: {
                    String separator = value.startsWith("-") ? " " : "";
                    return "-" + separator + value;
                }
                case PLUS: {
                    return "+" + value;
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + node.getSign());
        }

        protected String visitArithmeticBinary(ArithmeticBinaryExpression node, Integer indent) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight(), indent);
        }

        protected String visitLikePredicate(LikePredicate node, Integer indent) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process((Node)node.getValue(), indent)).append(" LIKE ").append((String)this.process((Node)node.getPattern(), indent));
            if (node.getEscape() != null) {
                builder.append(" ESCAPE ").append((String)this.process((Node)node.getEscape(), indent));
            }
            builder.append(')');
            return builder.toString();
        }

        protected String visitAllColumns(AllColumns node, Integer indent) {
            if (node.getPrefix().isPresent()) {
                return node.getPrefix().get() + ".*";
            }
            return "*";
        }

        public String visitCast(Cast node, Integer indent) {
            return (node.isSafe() ? "TRY_CAST" : "CAST") + "(" + (String)this.process((Node)node.getExpression(), indent) + " AS " + node.getType() + ")";
        }

        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Integer indent) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process((Node)whenClause, indent));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Node)value, indent)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Integer indent) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add(this.process((Node)node.getOperand(), indent));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process((Node)whenClause, indent));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Node)value, indent)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        protected String visitWhenClause(WhenClause node, Integer indent) {
            return "WHEN " + (String)this.process((Node)node.getOperand(), indent) + " THEN " + (String)this.process((Node)node.getResult(), indent);
        }

        protected String visitBetweenPredicate(BetweenPredicate node, Integer indent) {
            return "(" + (String)this.process((Node)node.getValue(), indent) + " BETWEEN " + (String)this.process((Node)node.getMin(), indent) + " AND " + (String)this.process((Node)node.getMax(), indent) + ")";
        }

        protected String visitInPredicate(InPredicate node, Integer indent) {
            return "(" + (String)this.process((Node)node.getValue(), indent) + " IN " + (String)this.process((Node)node.getValueList(), indent) + ")";
        }

        protected String visitInListExpression(InListExpression node, Integer indent) {
            StringBuilder builder = new StringBuilder("(");
            boolean first = true;
            for (Expression expression : node.getValues()) {
                builder.append("\n").append(StatementFormatter.indentString(indent + 1)).append(first ? "  " : ", ").append((String)this.process((Node)expression, indent + 1));
                first = false;
            }
            return builder.append(")").toString();
        }

        private String visitFilter(Expression node, Integer indent) {
            return "(WHERE " + (String)this.process((Node)node, indent) + ')';
        }

        public String visitWindow(Window node, Integer indent) {
            ArrayList<Object> parts = new ArrayList<Object>();
            if (!node.getPartitionBy().isEmpty()) {
                parts.add("PARTITION BY " + this.joinExpressions(node.getPartitionBy(), indent));
            }
            if (!node.getOrderBy().isEmpty()) {
                parts.add("ORDER BY " + ExpressionFormatter.formatSortItems(node.getOrderBy(), this.parameters, indent));
            }
            if (node.getFrame().isPresent()) {
                parts.add(this.process((Node)node.getFrame().get(), indent));
            }
            return '(' + Joiner.on((char)' ').join(parts) + ')';
        }

        public String visitWindowFrame(WindowFrame node, Integer indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString()).append(' ');
            if (node.getEnd().isPresent()) {
                builder.append("BETWEEN ").append((String)this.process((Node)node.getStart(), indent)).append(" AND ").append((String)this.process((Node)node.getEnd().get(), indent));
            } else {
                builder.append((String)this.process((Node)node.getStart(), indent));
            }
            return builder.toString();
        }

        public String visitFrameBound(FrameBound node, Integer indent) {
            switch (node.getType()) {
                case UNBOUNDED_PRECEDING: {
                    return "UNBOUNDED PRECEDING";
                }
                case PRECEDING: {
                    return (String)this.process((Node)node.getValue().get(), indent) + " PRECEDING";
                }
                case CURRENT_ROW: {
                    return "CURRENT ROW";
                }
                case FOLLOWING: {
                    return (String)this.process((Node)node.getValue().get(), indent) + " FOLLOWING";
                }
                case UNBOUNDED_FOLLOWING: {
                    return "UNBOUNDED FOLLOWING";
                }
            }
            throw new IllegalArgumentException("unhandled type: " + node.getType());
        }

        protected String visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Integer indent) {
            return (String)this.process((Node)node.getValue(), indent) + ' ' + node.getComparisonType().getValue() + ' ' + node.getQuantifier().toString() + ' ' + (String)this.process((Node)node.getSubquery(), indent);
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right, Integer indent) {
            return "(" + (String)this.process((Node)left, indent + 1) + ' ' + operator + ' ' + (String)this.process((Node)right, indent + 1) + ')';
        }

        private String joinExpressions(List<Expression> expressions, Integer indent) {
            return Joiner.on((String)", ").join(expressions.stream().map(e -> (String)this.process((Node)e, indent)).iterator());
        }

        private static String formatIdentifier(String s) {
            return '\"' + s + '\"';
        }
    }
}

