/*
 * Decompiled with CFR 0.152.
 */
package rocks.prestodb.query.formatter;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.StatementSplitter;
import com.facebook.presto.sql.tree.Node;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.Set;
import rocks.prestodb.query.formatter.StatementFormatter;

public class Main {
    private static final SqlParser SQL_PARSER = new SqlParser();

    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
            String sql;
            StringBuilder buffer = new StringBuilder();
            while (reader.ready()) {
                buffer.append(reader.readLine() + "\n");
                sql = buffer.toString();
                StatementSplitter splitter = new StatementSplitter(sql, (Set)ImmutableSet.of((Object)";", (Object)"\\G"));
                for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                    Main.format(split.statement());
                }
                buffer = new StringBuilder();
                String partial = splitter.getPartialStatement();
                if (partial.isEmpty()) continue;
                buffer.append(partial).append('\n');
            }
            sql = buffer.toString();
            if (!sql.isEmpty()) {
                Main.format(sql);
            }
        }
    }

    private static void format(String sql) {
        System.out.println(StatementFormatter.formatSql((Node)SQL_PARSER.createStatement(sql), Optional.empty()) + ";");
    }
}

