/*
 * Decompiled with CFR 0.152.
 */
package rocks.prestodb.query.formatter;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import rocks.prestodb.query.formatter.StatementFormatter;

public class TestStatementFormatter {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void test() {
        this.queries().forEach(this::testQuery);
    }

    private void testQuery(String query) {
        System.out.println(">>>> Testing: " + query);
        Statement statement = SQL_PARSER.createStatement(query);
        String formmatted = StatementFormatter.formatSql((Node)statement);
        System.out.println(formmatted);
        Assert.assertEquals((Object)formmatted, (Object)StatementFormatter.formatSql((Node)SQL_PARSER.createStatement(formmatted)));
    }

    @Test
    public void testQuery() {
        this.testQuery("SELECT (1 = ANY(SELECT 1)) ");
        this.testQuery("SELECT (1 = ANY(SELECT 1)) IN (SELECT TRUE)");
    }

    private Stream<String> queries() {
        return new BufferedReader(new InputStreamReader(TestStatementFormatter.class.getResourceAsStream("/queries.txt"))).lines();
    }
}

