/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.addr;

import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.addr.Jid;

public class JidTest {
    public static void main1(String[] args) {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(() -> {
            ExecutorService executor1 = Executors.newCachedThreadPool();
            for (int i = 0; i < 100; ++i) {
                executor1.execute(() -> {
                    int j = 0;
                    while (true) {
                        Jid.of((String)(++j + "@test"));
                        if (j != 3000) continue;
                        j = 0;
                    }
                });
            }
        });
    }

    @Test
    public void testJidDomainOnly() {
        Jid jid = Jid.ofDomain((String)"domain");
        Assert.assertEquals((String)"domain", (String)jid.toString());
    }

    @Test
    public void testJidNodeAndDomain() {
        Jid jid = Jid.ofLocalAndDomain((String)"node", (String)"domain");
        Assert.assertEquals((String)"node@domain", (String)jid.toString());
    }

    @Test
    public void testJidFull() {
        Jid jid = Jid.of((String)"node", (String)"domain", (String)"resource");
        Assert.assertEquals((String)"node@domain/resource", (String)jid.toString());
    }

    @Test
    public void testJidParseDomain() {
        Jid jid = Jid.of((String)"domain.com");
        Assert.assertEquals((String)"domain.com", (String)jid.toString());
    }

    @Test
    public void testJidFromEscapedString() {
        Jid jid = Jid.of((String)"domain");
        Assert.assertEquals((String)"domain", (String)jid.toString());
        Jid jid2 = Jid.of((String)"domain/resource");
        Assert.assertEquals((String)"domain/resource", (String)jid2.toString());
        Jid jid3 = Jid.of((String)"local@domain");
        Assert.assertEquals((String)"local@domain", (String)jid3.toString());
        Jid jid4 = Jid.of((String)"local@domain/resource");
        Assert.assertEquals((String)"local@domain/resource", (String)jid4.toString());
    }

    @Test
    public void testJidParseNode() {
        Jid jid = Jid.of((String)"node@domain");
        Assert.assertEquals((String)"node@domain", (String)jid.toString());
    }

    @Test
    public void testJidParseFull() {
        Jid jid = Jid.of((String)"node@domain/resource");
        Assert.assertEquals((String)"node@domain/resource", (String)jid.toString());
    }

    @Test
    public void testBareJid() {
        Jid jid = Jid.of((String)"node@domain/resource");
        Assert.assertEquals((String)"node@domain", (String)jid.asBareJid().toString());
    }

    @Test
    public void testJidParseDomainAndResource() {
        Jid jid = Jid.of((String)"domain/resource");
        Assert.assertEquals((String)"domain/resource", (String)jid.toString());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testJidIncomplete1() {
        Jid.of((String)"@domain");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testJidIncomplete2() {
        Jid.of((String)"domain/");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testJidNull() {
        Jid.of(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testJidEmpty() {
        Jid.of((String)"");
    }

    @Test
    public void testJidTrim() {
        Jid jid = Jid.of((String)" node@domain/resource ");
        Assert.assertEquals((String)"node@domain/resource", (String)jid.toString());
    }

    @Test
    public void testJidEquals() {
        Jid jid1 = Jid.of((String)"node@domain/resource");
        Jid jid2 = Jid.of((String)"node@domain/resource");
        Assert.assertEquals((Object)jid1, (Object)jid2);
        Jid jid3 = Jid.of((String)"node@domain/test");
        Assert.assertNotEquals((Object)jid1, (Object)jid3);
        Jid jid4 = Jid.of((String)"node@domain");
        Assert.assertNotEquals((Object)jid1, (Object)jid4);
    }

    @Test
    public void testIsBareJid() {
        Jid jid = Jid.of((String)"node@domain");
        Assert.assertTrue((boolean)jid.isBareJid());
        Assert.assertFalse((boolean)jid.isFullJid());
    }

    @Test
    public void testIsFullJid() {
        Jid jid = Jid.of((String)"node@domain/resource");
        Assert.assertTrue((boolean)jid.isFullJid());
        Assert.assertFalse((boolean)jid.isBareJid());
    }

    @Test
    public void testGetter() {
        Jid jid = Jid.of((String)"node@domain/resource");
        Assert.assertEquals((String)jid.getDomain(), (String)"domain");
        Assert.assertEquals((String)jid.getLocal(), (String)"node");
        Assert.assertEquals((String)jid.getResource(), (String)"resource");
    }

    @Test
    public void testWithJidAsResource() {
        Jid jid = Jid.of((String)"node\u046a34-23?\u0498@domain/user@conference.com/nick");
        Assert.assertEquals((String)jid.getDomain(), (String)"domain");
        Assert.assertEquals((String)jid.getLocal(), (String)"node\u046b34-23?\u0499");
        Assert.assertEquals((String)jid.getResource(), (String)"user@conference.com/nick");
    }

    @Test
    public void testJidEscaping() {
        Jid jid = Jid.of((String)"d'artagnan@musketeers.lit");
        Assert.assertEquals((String)jid.toString(), (String)"d'artagnan@musketeers.lit");
        Assert.assertEquals((String)jid.toEscapedString(), (String)"d\\27artagnan@musketeers.lit");
        Jid jid2 = Jid.of((String)"d\\27artagnan@musketeers.lit");
        Assert.assertEquals((String)jid2.toString(), (String)"d\\27artagnan@musketeers.lit");
        Assert.assertEquals((String)jid2.toEscapedString(), (String)"d\\5c27artagnan@musketeers.lit");
        Jid jid3 = Jid.of((String)"treville\\40musketeers.lit@smtp.gascon.fr");
        Assert.assertEquals((String)jid3.getLocal(), (String)"treville\\40musketeers.lit");
        Assert.assertEquals((String)jid3.toString(), (String)"treville\\40musketeers.lit@smtp.gascon.fr");
        Assert.assertEquals((String)jid3.toEscapedString(), (String)"treville\\5c40musketeers.lit@smtp.gascon.fr");
        Jid jid4 = Jid.of((String)"\"& '/:<>@\\@domain/resource");
        Assert.assertEquals((String)jid4.toEscapedString(), (String)"\\22\\26\\20\\27\\2f\\3a\\3c\\3e\\40\\@domain/resource");
        Assert.assertEquals((String)jid4.toString(), (String)"\"& '/:<>@\\@domain/resource");
        Jid jid5 = Jid.of((String)"treville\\5cmusketeers.lit@smtp.gascon.fr");
        Assert.assertEquals((String)jid5.toEscapedString(), (String)"treville\\5c5cmusketeers.lit@smtp.gascon.fr");
    }

    @Test
    public void testJidEscapingExceptions() {
        Jid jid = Jid.of((String)"\\2plus\\2is\\4@domain");
        Assert.assertEquals((String)jid.toString(), (String)"\\2plus\\2is\\4@domain");
        Assert.assertEquals((String)jid.toEscapedString(), (String)"\\2plus\\2is\\4@domain");
        Jid jid2 = Jid.of((String)"foo\\bar@domain");
        Assert.assertEquals((String)jid2.toString(), (String)"foo\\bar@domain");
        Assert.assertEquals((String)jid2.toEscapedString(), (String)"foo\\bar@domain");
        Jid jid3 = Jid.of((String)"foob\\41r@domain");
        Assert.assertEquals((String)jid3.toString(), (String)"foob\\41r@domain");
        Assert.assertEquals((String)jid3.toEscapedString(), (String)"foob\\41r@domain");
        Jid jid4 = Jid.of((String)"c:\\5commas@example.com");
        Assert.assertEquals((String)jid4.toString(), (String)"c:\\5commas@example.com");
        Assert.assertEquals((String)jid4.toEscapedString(), (String)"c\\3a\\5c5commas@example.com");
    }

    @Test
    public void testJidEscapingExamples() {
        Jid jid1 = Jid.of((String)"space cadet@example.com");
        Assert.assertEquals((String)jid1.toEscapedString(), (String)"space\\20cadet@example.com");
        Assert.assertEquals((String)jid1.toString(), (String)"space cadet@example.com");
        Jid jid2 = Jid.of((String)"call me \"ishmael\"@example.com");
        Assert.assertEquals((String)jid2.toEscapedString(), (String)"call\\20me\\20\\22ishmael\\22@example.com");
        Assert.assertEquals((String)jid2.toString(), (String)"call me \"ishmael\"@example.com");
        Jid jid3 = Jid.of((String)"at&t guy@example.com");
        Assert.assertEquals((String)jid3.toEscapedString(), (String)"at\\26t\\20guy@example.com");
        Assert.assertEquals((String)jid3.toString(), (String)"at&t guy@example.com");
        Jid jid4 = Jid.of((String)"d'artagnan@example.com");
        Assert.assertEquals((String)jid4.toEscapedString(), (String)"d\\27artagnan@example.com");
        Assert.assertEquals((String)jid4.toString(), (String)"d'artagnan@example.com");
        Jid jid5 = Jid.of((String)"/.fanboy@example.com");
        Assert.assertEquals((String)jid5.toEscapedString(), (String)"\\2f.fanboy@example.com");
        Assert.assertEquals((String)jid5.toString(), (String)"/.fanboy@example.com");
        Jid jid6 = Jid.of((String)"::foo::@example.com");
        Assert.assertEquals((String)jid6.toEscapedString(), (String)"\\3a\\3afoo\\3a\\3a@example.com");
        Assert.assertEquals((String)jid6.toString(), (String)"::foo::@example.com");
        Jid jid7 = Jid.of((String)"<foo>@example.com");
        Assert.assertEquals((String)jid7.toEscapedString(), (String)"\\3cfoo\\3e@example.com");
        Assert.assertEquals((String)jid7.toString(), (String)"<foo>@example.com");
        Jid jid8 = Jid.of((String)"user@host@example.com");
        Assert.assertEquals((String)jid8.toEscapedString(), (String)"user\\40host@example.com");
        Assert.assertEquals((String)jid8.toString(), (String)"user@host@example.com");
        Jid jid9 = Jid.of((String)"c:\\net@example.com");
        Assert.assertEquals((String)jid9.toEscapedString(), (String)"c\\3a\\net@example.com");
        Assert.assertEquals((String)jid9.toString(), (String)"c:\\net@example.com");
        Jid jid10 = Jid.of((String)"c:\\\\net@example.com");
        Assert.assertEquals((String)jid10.toEscapedString(), (String)"c\\3a\\\\net@example.com");
        Assert.assertEquals((String)jid10.toString(), (String)"c:\\\\net@example.com");
        Jid jid11 = Jid.of((String)"c:\\cool stuff@example.com");
        Assert.assertEquals((String)jid11.toEscapedString(), (String)"c\\3a\\cool\\20stuff@example.com");
        Assert.assertEquals((String)jid11.toString(), (String)"c:\\cool stuff@example.com");
        Jid jid12 = Jid.of((String)"c:\\5commas@example.com");
        Assert.assertEquals((String)jid12.toEscapedString(), (String)"c\\3a\\5c5commas@example.com");
        Assert.assertEquals((String)jid12.toString(), (String)"c:\\5commas@example.com");
        Jid jid13 = Jid.of((String)"\\3and\\2is\\5cool@example.com");
        Assert.assertEquals((String)jid13.toEscapedString(), (String)"\\5c3and\\2is\\5c5cool@example.com");
        Assert.assertEquals((String)jid13.toString(), (String)"\\3and\\2is\\5cool@example.com");
    }

    @Test
    public void testComplexUnescape() {
        Jid jid14 = Jid.ofEscaped((String)"\\5c3and\\2is\\5c5cool@example.com");
        Assert.assertEquals((String)jid14.toEscapedString(), (String)"\\5c3and\\2is\\5c5cool@example.com");
        Assert.assertEquals((String)jid14.toString(), (String)"\\3and\\2is\\5cool@example.com");
    }

    @Test
    public void testComplexJid() {
        Jid jid = Jid.of((String)"d'art@a/gnan@musketeers.lit/another/@Jid@test.de");
        Assert.assertEquals((String)jid.getLocal(), (String)"d'art");
        Assert.assertEquals((String)jid.getDomain(), (String)"a");
        Assert.assertEquals((String)jid.getResource(), (String)"gnan@musketeers.lit/another/@Jid@test.de");
    }

    @Test
    public void testHostname() {
        Jid jid = Jid.of((String)"typical-hostname33.whatever.co.uk");
        Assert.assertEquals((String)jid.getDomain(), (String)"typical-hostname33.whatever.co.uk");
        Jid jid2 = Jid.of((String)"conference.server123");
        Assert.assertEquals((String)jid2.getDomain(), (String)"conference.server123");
    }

    @Test
    public void testIpAddress() {
        Jid jid = Jid.of((String)"127.0.0.1");
        Assert.assertEquals((String)jid.getDomain(), (String)"127.0.0.1");
    }

    @Test
    public void testDoubleAt() {
        Jid jid = Jid.ofEscaped((String)"name@mail.de@chat.facebook.com/LPfS9dVP");
        Assert.assertEquals((String)jid.getLocal(), (String)"name@mail.de");
        Assert.assertEquals((String)jid.getDomain(), (String)"chat.facebook.com");
        Assert.assertEquals((String)jid.getResource(), (String)"LPfS9dVP");
        Assert.assertEquals((String)jid.toEscapedString(), (String)"name\\40mail.de@chat.facebook.com/LPfS9dVP");
    }

    @Test
    public void testWithResource() {
        Jid jid = Jid.of((String)"test@domain");
        Jid withReource = jid.withResource("resource");
        Assert.assertEquals((Object)withReource, (Object)Jid.of((String)"test@domain/resource"));
    }

    @Test
    public void testWithLocal() {
        Jid jid = Jid.of((String)"test@domain/resource");
        Jid withLocal = jid.withLocal("newLocal");
        Assert.assertEquals((Object)withLocal, (Object)Jid.of((String)"newLocal@domain/resource"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWithIllegalChars() {
        Jid.of((String)"test\u001ftest@domain");
    }

    @Test
    public void testAsciiControlCharacters() {
        String[] chars = new String[]{"\u0000", "\u001f", "\u007f", "\ud83f\udffe"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                Jid.prepare((String)aChar, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testSurrogateCodes() {
        String[] chars = new String[]{"\ud800", "\udfff"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                Jid.prepare((String)aChar, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testNonAsciiControlCharacters() {
        String[] chars = new String[]{"\u0080", "\u06dd", "\u070f", "\u180e", "\u2028", "\u2029", "\u2061", "\u2062", "\u2063", "\u206a", "\u206b", "\u206c", "\u206d", "\u206e", "\u206f", "\ufff9", "\ufffa", "\ufffb", "\ud834\udd73", "\ud834\udd7a"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                Jid.prepare((String)aChar, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testPrivateUseCharacters() {
        String[] chars = new String[]{"\ue000", "\uf8ff", "\udb80\udc00", "\udbc0\udc00"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                Jid.prepare((String)aChar, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testNonCharacterCodePoints() {
        String[] chars = new String[]{"\ufdd0", "\ufdef"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                Jid.prepare((String)aChar, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testNodePrep() throws StringprepException {
        String s = "\u0149@domain";
        Assert.assertEquals((String)Jid.of((String)s).getLocal(), (String)"\u02bcn");
        String s1 = "\u00df@domain";
        Assert.assertEquals((String)Jid.of((String)s1).getLocal(), (String)"ss");
        String s2 = "\u03b0@domain";
        Assert.assertEquals((String)Jid.of((String)s2).getLocal(), (String)Stringprep.nodeprep((String)"\u03b0"));
        String s3 = "\u01e0@domain";
        Assert.assertEquals((String)Jid.of((String)s3).getLocal(), (String)"\u01e1");
        String s4 = "\u0226@domain";
        Assert.assertEquals((String)Jid.of((String)s4).getLocal(), (String)"\u0227");
        String s5 = "\u3394@domain";
        Assert.assertEquals((String)Jid.of((String)s5).getLocal(), (String)Stringprep.nodeprep((String)"\u3394"));
        String s6 = "\u0480@domain";
        Assert.assertEquals((String)Jid.of((String)s6).getLocal(), (String)"\u0481");
        String s7 = "\u0587@domain";
        Assert.assertEquals((String)Jid.of((String)s7).getLocal(), (String)"\u0565\u0582");
        String s8 = "\u1f52@domain";
        Assert.assertEquals((String)Jid.of((String)s8).getLocal(), (String)Stringprep.nodeprep((String)"\u1f52"));
        String s9 = "UPPERCASE@domain";
        Assert.assertEquals((String)Jid.of((String)s9).getLocal(), (String)"uppercase");
        String s10 = "\u212d@domain";
        Assert.assertEquals((String)Jid.of((String)s10).getLocal(), (String)Stringprep.nodeprep((String)"\u212d"));
    }

    @Test
    public void testResourcePrep() {
        String s1 = "test@domain/resource with space";
        Assert.assertEquals((String)Jid.of((String)s1).getResource(), (String)"resource with space");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidBidiString() {
        String s = "\u06271@domain";
        Jid.of((String)s);
    }

    @Test
    public void testValidBidiString() {
        String s = "\u06271\u0628@domain";
        Assert.assertEquals((String)Jid.of((String)s).getLocal(), (String)"\u06271\u0628");
    }

    @Test
    public void testProhibitedChars() {
        String[] str = new String[]{"\u200e", "\u200f", "\u202a", "\u202b", "\u202c", "\u202d", "\u202e", "\u206a", "\u206b", "\u206c", "\u206d", "\u206e", "\u206f"};
        int fails = 0;
        for (String s : str) {
            try {
                Jid.of((String)(s + "@domain"));
            }
            catch (Exception e) {
                ++fails;
            }
        }
        Assert.assertEquals((int)fails, (int)13);
    }

    @Test
    public void shouldMapToNothing() {
        String s = "s\u00ad\u034f\u1806\u180b\u180c\u180d\u200b\u200c\u200d\u2060\ufe00\ufe01\ufe02\ufe03\ufe04\ufe05\ufe06\ufe07\ufe08\ufe09\ufe0a\ufe0b\ufe0c\ufe0d\ufe0e\ufe0f\ufeffs";
        Assert.assertEquals((String)Jid.prepare((String)s, (boolean)true), (String)"ss");
    }

    @Test
    public void shouldCaseFold() {
        String s = "\u0149";
        Assert.assertEquals((String)Jid.prepare((String)s, (boolean)true), (String)"\u02bcn");
        String s1 = "\u00df";
        Assert.assertEquals((String)Jid.prepare((String)s1, (boolean)true), (String)"ss");
        String s3 = "\u01e0";
        Assert.assertEquals((String)Jid.prepare((String)s3, (boolean)true), (String)"\u01e1");
        String s4 = "\u0226";
        Assert.assertEquals((String)Jid.prepare((String)s4, (boolean)true), (String)"\u0227");
        String s6 = "\u0480";
        Assert.assertEquals((String)Jid.prepare((String)s6, (boolean)true), (String)"\u0481");
        String s7 = "\u0587";
        Assert.assertEquals((String)Jid.prepare((String)s7, (boolean)true), (String)"\u0565\u0582");
    }

    public void testPerformance() {
        long start = System.currentTimeMillis();
        Jid.of((String)"test1@DOMAIN");
        for (int i = 0; i < 10000; ++i) {
            Jid.of((String)(UUID.randomUUID().toString() + "@DOMAIN"));
        }
        Jid.of((String)"test1@DOMAIN");
        System.out.println(System.currentTimeMillis() - start);
    }

    @Test
    public void testComparable() {
        ArrayList<Object> jids = new ArrayList<Object>();
        Jid jid1 = Jid.of((String)"aaa");
        Jid jid2 = Jid.of((String)"a@aaa");
        Jid jid3 = Jid.of((String)"b@aaa");
        Jid jid4 = Jid.of((String)"b@aaa/resource");
        Jid jid5 = Jid.of((String)"c@aaa");
        Jid jid6 = Jid.of((String)"a@bbb");
        Jid jid7 = Jid.of((String)"a@ccc");
        Jid jid8 = Jid.of((String)"b@ccc");
        jids.add(jid1);
        jids.add(jid2);
        jids.add(jid3);
        jids.add(jid4);
        jids.add(jid5);
        jids.add(jid6);
        jids.add(jid7);
        jids.add(jid8);
        Collections.shuffle(jids);
        jids.sort(null);
        Assert.assertEquals(jids.get(0), (Object)jid1);
        Assert.assertEquals(jids.get(1), (Object)jid2);
        Assert.assertEquals(jids.get(2), (Object)jid3);
        Assert.assertEquals(jids.get(3), (Object)jid4);
        Assert.assertEquals(jids.get(4), (Object)jid5);
        Assert.assertEquals(jids.get(5), (Object)jid6);
        Assert.assertEquals(jids.get(6), (Object)jid7);
        Assert.assertEquals(jids.get(7), (Object)jid8);
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        Jid jid = Jid.of((String)"local@domain/resource");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(jid);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteArrayInputStream);
        Jid readJid = (Jid)in.readObject();
        Assert.assertNotNull((Object)readJid);
        Assert.assertEquals((Object)readJid, (Object)jid);
    }
}

