/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.addr;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.Bidi;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.JidAdapter;

@XmlJavaTypeAdapter(value=JidAdapter.class)
public final class Jid
implements Comparable<Jid>,
Serializable,
CharSequence {
    public static final String ESCAPING_FEATURE = "jid\\20escaping";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[ \"&'/:<>@]|\\\\(?=20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\\\\(20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern PROHIBITED_CHARACTERS = Pattern.compile("[^\\p{L}\\p{N}\\p{P}\\p{S}\\p{M}\\s]|[\u0340\u0341]");
    private static final String DOMAIN_PART = "((?:(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))+)";
    private static final Pattern JID = Pattern.compile("^((.*?)@)?((?:(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))+)(/(.*))?$");
    private static final Pattern MAP_TO_NOTHING = Pattern.compile("([\u00ad\u034f\u1806\u180b-\u180d\u200b-\u200d\u2060\ufe00-\ufe0f\ufeff])");
    private static final LruCache<String, Jid> ESCAPED_CACHE = new LruCache(5000);
    private static final LruCache<String, Jid> UNESCAPED_CACHE = new LruCache(5000);
    private static final long serialVersionUID = -3824234106101731424L;
    private final String escapedLocal;
    private final String local;
    private final String domain;
    private final String resource;

    @Deprecated
    public Jid(String domain) {
        this(null, domain, null);
    }

    @Deprecated
    public Jid(String local, String domain) {
        this(local, domain, null);
    }

    @Deprecated
    public Jid(CharSequence local, CharSequence domain, CharSequence resource) {
        this(local, domain, resource, false, true);
    }

    private Jid(CharSequence local, CharSequence domain, CharSequence resource, boolean doUnescape, boolean prepareAndValidate) {
        String preparedNode;
        String strLocal = local != null ? local.toString() : null;
        String strDomain = domain.toString();
        if (prepareAndValidate) {
            preparedNode = Jid.prepare(strLocal, true);
            Jid.validateDomain(strDomain);
            Jid.validateLength(preparedNode, "local");
        } else {
            preparedNode = strLocal;
        }
        String preparedResource = Jid.prepare(resource != null ? resource.toString() : null, false);
        Jid.validateLength(preparedResource, "resource");
        this.local = doUnescape ? Jid.unescape(preparedNode) : preparedNode;
        this.escapedLocal = Jid.escape(this.local);
        this.domain = strDomain.toLowerCase();
        this.resource = preparedResource;
    }

    @Deprecated
    public static Jid valueOf(String jid) {
        return Jid.of(jid);
    }

    @Deprecated
    public static Jid valueOf(String jid, boolean doUnescape) {
        return Jid.of(jid, doUnescape);
    }

    public static Jid of(CharSequence local, CharSequence domain, CharSequence resource) {
        return new Jid(local, domain, resource);
    }

    public static Jid ofDomain(CharSequence domain) {
        return new Jid(null, domain, null);
    }

    public static Jid ofLocalAndDomain(CharSequence local, CharSequence domain) {
        return new Jid(local, domain, null);
    }

    public static Jid ofDomainAndResource(CharSequence domain, CharSequence resource) {
        return new Jid(null, domain, resource);
    }

    public static Jid of(CharSequence jid) {
        return Jid.of(jid.toString(), false);
    }

    public static Jid ofEscaped(CharSequence jid) {
        return Jid.of(jid.toString(), true);
    }

    private static Jid of(String jid, boolean doUnescape) {
        Objects.requireNonNull(jid, "jid must not be null.");
        jid = jid.trim();
        if (jid.isEmpty()) {
            throw new IllegalArgumentException("jid must not be empty.");
        }
        Jid result = doUnescape ? (Jid)((LruCache)Jid.UNESCAPED_CACHE).get(jid) : (Jid)((LruCache)Jid.ESCAPED_CACHE).get(jid);
        if (result != null) {
            return result;
        }
        Matcher matcher = JID.matcher(jid);
        if (matcher.matches()) {
            Jid jidValue = new Jid(matcher.group(2), matcher.group(3), matcher.group(8), doUnescape, true);
            if (doUnescape) {
                ((LruCache)Jid.UNESCAPED_CACHE).put(jid, jidValue);
            } else {
                ((LruCache)Jid.ESCAPED_CACHE).put(jid, jidValue);
            }
            return jidValue;
        }
        throw new IllegalArgumentException("Could not parse JID: " + jid);
    }

    private static String escape(String jid) {
        if (jid != null) {
            Matcher matcher = ESCAPE_PATTERN.matcher(jid);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group();
                matcher.appendReplacement(sb, String.format("\\\\%x", match.getBytes(StandardCharsets.UTF_8)[0]));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private static String unescape(String jid) {
        if (jid != null) {
            Matcher matcher = UNESCAPE_PATTERN.matcher(jid);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group(1);
                int num = Integer.parseInt(match, 16);
                String value = String.valueOf((char)num);
                if (value.equals("\\")) {
                    matcher.appendReplacement(sb, "\\\\");
                    continue;
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    static String prepare(String input, boolean isLocalPart) {
        if (input != null) {
            Bidi bidi;
            Matcher matcher;
            String prepared = MAP_TO_NOTHING.matcher(input).replaceAll("");
            if (isLocalPart) {
                prepared = prepared.toUpperCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            }
            prepared = Normalizer.normalize(prepared, Normalizer.Form.NFKC);
            if (isLocalPart) {
                prepared = prepared.toLowerCase(Locale.ENGLISH);
            }
            if ((matcher = PROHIBITED_CHARACTERS.matcher(prepared)).find()) {
                throw new IllegalArgumentException("Local or resource part contains prohibited characters.");
            }
            if (Bidi.requiresBidi(prepared.toCharArray(), 0, prepared.length()) && (bidi = new Bidi(input, 0)).isMixed() && (bidi.getLevelAt(0) != 1 || bidi.getLevelAt(0) != bidi.getLevelAt(input.length() - 1))) {
                throw new IllegalArgumentException("Local or resource part contains mixed bidirectional characters.");
            }
            return prepared;
        }
        return null;
    }

    private static void validateDomain(String domain) {
        Objects.requireNonNull(domain, "domain must not be null.");
        if (domain.contains("@")) {
            throw new IllegalArgumentException("domain must not contain a '@' sign");
        }
        Jid.validateLength(domain, "domain");
    }

    private static void validateLength(String value, String part) {
        if (value != null) {
            if (value.isEmpty()) {
                throw new IllegalArgumentException(part + " must not be empty.");
            }
            if (value.length() > 1023) {
                throw new IllegalArgumentException(part + " must not be greater than 1023 characters.");
            }
        }
    }

    public final boolean isFullJid() {
        return this.resource != null;
    }

    public final boolean isBareJid() {
        return this.resource == null;
    }

    public final Jid asBareJid() {
        return new Jid(this.local, this.domain, null, false, false);
    }

    public final Jid withLocal(String local) {
        return new Jid(local, this.domain, this.resource, false, true);
    }

    public final Jid withResource(String resource) {
        return new Jid(this.local, this.domain, resource, false, true);
    }

    public final Jid atSubdomain(String subdomain) {
        return new Jid(this.local, Objects.requireNonNull(subdomain) + "." + this.domain, this.resource, false, true);
    }

    public final String getLocal() {
        return this.local;
    }

    public final String getDomain() {
        return this.domain;
    }

    public final String getResource() {
        return this.resource;
    }

    public final String toEscapedString() {
        return Jid.toString(this.escapedLocal, this.domain, this.resource);
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public final String toString() {
        return Jid.toString(this.local, this.domain, this.resource);
    }

    private static String toString(String local, String domain, String resource) {
        StringBuilder sb = new StringBuilder();
        if (local != null) {
            sb.append(local).append('@');
        }
        sb.append(domain);
        if (resource != null) {
            sb.append('/').append(resource);
        }
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jid)) {
            return false;
        }
        Jid other = (Jid)o;
        return Objects.equals(this.local, other.local) && Objects.equals(this.domain, other.domain) && Objects.equals(this.resource, other.resource);
    }

    public final int hashCode() {
        return Objects.hash(this.local, this.domain, this.resource);
    }

    @Override
    public final int compareTo(Jid o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            if (this.domain != null) {
                result = o.domain != null ? this.domain.compareTo(o.domain) : -1;
            } else {
                int n = result = o.domain != null ? 1 : 0;
            }
            if (result == 0) {
                if (this.local != null) {
                    result = o.local != null ? this.local.compareTo(o.local) : 1;
                } else {
                    int n = result = o.local != null ? -1 : 0;
                }
            }
            if (result == 0) {
                if (this.resource != null) {
                    return o.resource != null ? this.resource.compareTo(o.resource) : 1;
                }
                return o.resource != null ? -1 : 0;
            }
            return result;
        }
        return -1;
    }

    private static final class LruCache<K, V> {
        private final int maxEntries;
        private final ConcurrentHashMap<K, V> map;
        private final ConcurrentLinkedQueue<K> queue;

        private LruCache(int maxEntries) {
            this.maxEntries = maxEntries;
            this.map = new ConcurrentHashMap(maxEntries);
            this.queue = new ConcurrentLinkedQueue();
        }

        private void put(K key, V value) {
            if (this.map.put(key, value) != null) {
                if (this.queue.remove(key)) {
                    this.queue.offer(key);
                }
            } else {
                this.queue.offer(key);
            }
            while (this.queue.size() > this.maxEntries) {
                K oldestKey = this.queue.poll();
                if (null == oldestKey) continue;
                this.map.remove(oldestKey);
            }
        }

        private V get(K key) {
            if (this.queue.remove(key)) {
                this.queue.offer(key);
            }
            return this.map.get(key);
        }
    }
}

