/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.addr;

import java.io.Serializable;
import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.text.Normalizer;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.JidAdapter;
import rocks.xmpp.precis.PrecisProfile;
import rocks.xmpp.precis.PrecisProfiles;
import rocks.xmpp.util.cache.LruCache;

@XmlJavaTypeAdapter(value=JidAdapter.class)
public final class Jid
implements Comparable<Jid>,
Serializable,
CharSequence {
    public static final String ESCAPING_FEATURE = "jid\\20escaping";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[ \"&'/:<>@]|\\\\(?=20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\\\\(20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final String DOMAIN_PART = "((?:(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))+)";
    private static final Pattern JID = Pattern.compile("^((.*?)@)?((?:(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))+)(/(.*))?$");
    private static final IDNProfile IDN_PROFILE = new IDNProfile();
    private static final Pattern LABEL_SEPARATOR = Pattern.compile("\u3002");
    private static final Map<CharSequence, Jid> ESCAPED_CACHE = new LruCache<CharSequence, Jid>(5000);
    private static final Map<CharSequence, Jid> UNESCAPED_CACHE = new LruCache<CharSequence, Jid>(5000);
    private static final long serialVersionUID = -3824234106101731424L;
    private final String escapedLocal;
    private final String local;
    private final String domain;
    private final String resource;

    private Jid(CharSequence local, CharSequence domain, CharSequence resource) {
        this(local, domain, resource, false, true);
    }

    private Jid(CharSequence local, CharSequence domain, CharSequence resource, boolean doUnescape, boolean enforceAndValidate) {
        String enforcedDomainPart;
        String enforcedResource;
        String enforcedLocalPart;
        String strDomain = Objects.requireNonNull(domain).toString().replaceAll("\\.$", "");
        String unescapedLocalPart = doUnescape ? Jid.unescape(local) : (local != null ? local.toString() : null);
        String escapedLocalPart = Jid.escape(unescapedLocalPart);
        if (enforceAndValidate) {
            enforcedLocalPart = escapedLocalPart != null ? PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)escapedLocalPart) : null;
            enforcedResource = resource != null ? PrecisProfiles.OPAQUE_STRING.enforce(resource) : null;
            enforcedDomainPart = IDN_PROFILE.enforce(strDomain);
            Jid.validateLength(enforcedLocalPart, "local");
            Jid.validateLength(enforcedResource, "resource");
            Jid.validateDomain(strDomain);
        } else {
            enforcedLocalPart = escapedLocalPart != null ? escapedLocalPart : null;
            enforcedResource = resource != null ? resource.toString() : null;
            enforcedDomainPart = strDomain;
        }
        this.local = Jid.unescape(enforcedLocalPart);
        this.escapedLocal = enforcedLocalPart;
        this.domain = enforcedDomainPart;
        this.resource = enforcedResource;
    }

    public static Jid of(CharSequence local, CharSequence domain, CharSequence resource) {
        return new Jid(local, domain, resource);
    }

    public static Jid ofDomain(CharSequence domain) {
        return new Jid(null, domain, null);
    }

    public static Jid ofLocalAndDomain(CharSequence local, CharSequence domain) {
        return new Jid(local, domain, null);
    }

    public static Jid ofDomainAndResource(CharSequence domain, CharSequence resource) {
        return new Jid(null, domain, resource);
    }

    public static Jid of(CharSequence jid) {
        return Jid.of(jid.toString(), false, true);
    }

    public static Jid ofEscaped(CharSequence jid) {
        return Jid.of(jid.toString(), true, false);
    }

    private static Jid of(String jid, boolean doUnescape, boolean enforceAndValidate) {
        Objects.requireNonNull(jid, "jid must not be null.");
        jid = jid.trim();
        if (jid.isEmpty()) {
            throw new IllegalArgumentException("jid must not be empty.");
        }
        Jid result = doUnescape ? UNESCAPED_CACHE.get(jid) : ESCAPED_CACHE.get(jid);
        if (result != null) {
            return result;
        }
        Matcher matcher = JID.matcher(jid);
        if (matcher.matches()) {
            Jid jidValue = new Jid(matcher.group(2), matcher.group(3), matcher.group(8), doUnescape, enforceAndValidate);
            if (doUnescape) {
                UNESCAPED_CACHE.put(jid, jidValue);
            } else {
                ESCAPED_CACHE.put(jid, jidValue);
            }
            return jidValue;
        }
        throw new IllegalArgumentException("Could not parse JID: " + jid);
    }

    private static String escape(CharSequence localPart) {
        if (localPart != null) {
            Matcher matcher = ESCAPE_PATTERN.matcher(localPart);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group();
                matcher.appendReplacement(sb, String.format("\\\\%x", match.getBytes(StandardCharsets.UTF_8)[0]));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private static String unescape(CharSequence localPart) {
        if (localPart != null) {
            Matcher matcher = UNESCAPE_PATTERN.matcher(localPart);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group(1);
                int num = Integer.parseInt(match, 16);
                String value = String.valueOf((char)num);
                if (value.equals("\\")) {
                    matcher.appendReplacement(sb, "\\\\");
                    continue;
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private static void validateDomain(String domain) {
        Objects.requireNonNull(domain, "domain must not be null.");
        if (domain.contains("@")) {
            throw new IllegalArgumentException("domain must not contain a '@' sign");
        }
        Jid.validateLength(domain, "domain");
    }

    private static void validateLength(CharSequence value, CharSequence part) {
        if (value != null) {
            if (value.length() == 0) {
                throw new IllegalArgumentException(part + " must not be empty.");
            }
            if (value.length() > 1023) {
                throw new IllegalArgumentException(part + " must not be greater than 1023 characters.");
            }
        }
    }

    public final boolean isFullJid() {
        return this.resource != null;
    }

    public final boolean isBareJid() {
        return this.resource == null;
    }

    public final Jid asBareJid() {
        return this.isBareJid() ? this : new Jid(this.local, this.domain, null, false, false);
    }

    public final Jid withLocal(CharSequence local) {
        return new Jid(local, this.domain, this.resource, false, true);
    }

    public final Jid withResource(CharSequence resource) {
        return new Jid(this.local, this.domain, resource, false, true);
    }

    public final Jid atSubdomain(CharSequence subdomain) {
        return new Jid(this.local, Objects.requireNonNull(subdomain) + "." + this.domain, this.resource, false, true);
    }

    public final String getLocal() {
        return this.local;
    }

    public final String getDomain() {
        return this.domain;
    }

    public final String getResource() {
        return this.resource;
    }

    public final String toEscapedString() {
        return Jid.toString(this.escapedLocal, this.domain, this.resource);
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public final String toString() {
        return Jid.toString(this.local, this.domain, this.resource);
    }

    private static String toString(String local, String domain, String resource) {
        StringBuilder sb = new StringBuilder();
        if (local != null) {
            sb.append(local).append('@');
        }
        sb.append(domain);
        if (resource != null) {
            sb.append('/').append(resource);
        }
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jid)) {
            return false;
        }
        Jid other = (Jid)o;
        return Objects.equals(this.local, other.local) && Objects.equals(this.domain, other.domain) && Objects.equals(this.resource, other.resource);
    }

    public final int hashCode() {
        return Objects.hash(this.local, this.domain, this.resource);
    }

    @Override
    public final int compareTo(Jid o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            Collator collator = Collator.getInstance();
            if (this.domain != null) {
                result = o.domain != null ? collator.compare(this.domain, o.domain) : -1;
            } else {
                int n = result = o.domain != null ? 1 : 0;
            }
            if (result == 0) {
                if (this.local != null) {
                    result = o.local != null ? collator.compare(this.local, o.local) : 1;
                } else {
                    int n = result = o.local != null ? -1 : 0;
                }
            }
            if (result == 0) {
                if (this.resource != null) {
                    return o.resource != null ? collator.compare(this.resource, o.resource) : 1;
                }
                return o.resource != null ? -1 : 0;
            }
            return result;
        }
        return -1;
    }

    private static final class IDNProfile
    extends PrecisProfile {
        private IDNProfile() {
            super(false);
        }

        public String prepare(CharSequence input) {
            return IDN.toUnicode(input.toString(), 2);
        }

        public String enforce(CharSequence input) {
            return this.applyAdditionalMappingRule(this.applyNormalizationRule(this.applyWidthMappingRule(this.applyCaseMappingRule(this.prepare(input))))).toString();
        }

        protected CharSequence applyWidthMappingRule(CharSequence charSequence) {
            return IDNProfile.widthMap((CharSequence)charSequence);
        }

        protected CharSequence applyAdditionalMappingRule(CharSequence charSequence) {
            return LABEL_SEPARATOR.matcher(charSequence).replaceAll(".");
        }

        protected CharSequence applyCaseMappingRule(CharSequence charSequence) {
            return charSequence.toString().toLowerCase();
        }

        protected CharSequence applyNormalizationRule(CharSequence charSequence) {
            return Normalizer.normalize(charSequence, Normalizer.Form.NFC);
        }

        protected CharSequence applyDirectionalityRule(CharSequence charSequence) {
            return charSequence;
        }
    }
}

