/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DirectoryCache
implements Map<String, byte[]> {
    private final Path cacheDirectory;

    public DirectoryCache(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public final int size() {
        final int[] size = new int[]{0};
        try {
            Files.walkFileTree(this.cacheDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size[0] = size[0] + 1;
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return size[0];
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        return Files.exists(this.cacheDirectory.resolve(key.toString()), new LinkOption[0]);
    }

    @Override
    public final boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] get(Object key) {
        Path file;
        if (key != null && !key.toString().isEmpty() && Files.isReadable(file = this.cacheDirectory.resolve(key.toString()))) {
            try {
                return Files.readAllBytes(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    @Override
    public final byte[] put(String key, byte[] value) {
        byte[] data = this.get(key);
        try {
            if (Files.notExists(this.cacheDirectory, new LinkOption[0])) {
                Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
            }
            Path file = this.cacheDirectory.resolve(key);
            Files.write(file, value, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return data;
    }

    @Override
    public final byte[] remove(Object key) {
        byte[] data = this.get(key);
        try {
            Files.deleteIfExists(this.cacheDirectory.resolve(key.toString()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return data;
    }

    @Override
    public final void putAll(Map<? extends String, ? extends byte[]> m) {
        for (Map.Entry<? extends String, ? extends byte[]> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final void clear() {
        try {
            Files.walkFileTree(this.cacheDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!Files.isSameFile(dir, DirectoryCache.this.cacheDirectory)) {
                        Files.deleteIfExists(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final Set<String> keySet() {
        HashSet<String> fileNames = new HashSet<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.cacheDirectory);){
            for (Path path : directoryStream) {
                fileNames.add(path.getFileName().toString());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Collections.unmodifiableSet(fileNames);
    }

    @Override
    public final Collection<byte[]> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<Map.Entry<String, byte[]>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

