/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.addr;

import java.util.Objects;
import rocks.xmpp.addr.AbstractJid;
import rocks.xmpp.addr.Jid;

public final class MalformedJid
extends AbstractJid {
    private static final long serialVersionUID = -2896737611021417985L;
    private final String localPart;
    private final String domainPart;
    private final String resourcePart;
    private final Throwable cause;

    static MalformedJid of(String jid, Throwable cause) {
        String localPart;
        String resourcePart;
        StringBuilder sb = new StringBuilder(jid);
        int indexOfResourceDelimiter = jid.indexOf(47);
        if (indexOfResourceDelimiter > -1) {
            resourcePart = sb.substring(indexOfResourceDelimiter + 1);
            sb.delete(indexOfResourceDelimiter, sb.length());
        } else {
            resourcePart = null;
        }
        int indexOfAt = jid.indexOf(64);
        if (indexOfAt > -1) {
            localPart = sb.substring(0, indexOfAt);
            sb.delete(0, indexOfAt + 1);
        } else {
            localPart = null;
        }
        return new MalformedJid(localPart, sb.toString(), resourcePart, cause);
    }

    private MalformedJid(String localPart, String domainPart, String resourcePart, Throwable cause) {
        this.localPart = localPart;
        this.domainPart = domainPart;
        this.resourcePart = resourcePart;
        this.cause = cause;
    }

    @Override
    public final Jid asBareJid() {
        return new MalformedJid(this.localPart, this.domainPart, null, this.cause);
    }

    @Override
    public Jid withLocal(CharSequence local) {
        return new MalformedJid(local.toString(), this.domainPart, this.resourcePart, this.cause);
    }

    @Override
    public Jid withResource(CharSequence resource) {
        return new MalformedJid(this.localPart, this.domainPart, resource.toString(), this.cause);
    }

    @Override
    public Jid atSubdomain(CharSequence subdomain) {
        return new MalformedJid(this.localPart, Objects.requireNonNull(subdomain) + "." + this.domainPart, this.resourcePart, this.cause);
    }

    @Override
    public final String getLocal() {
        return this.localPart;
    }

    @Override
    public final String getEscapedLocal() {
        return this.localPart;
    }

    @Override
    public final String getDomain() {
        return this.domainPart;
    }

    @Override
    public final String getResource() {
        return this.resourcePart;
    }

    public final Throwable getCause() {
        return this.cause;
    }
}

