/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.addr;

import java.text.Collator;
import java.util.Objects;
import rocks.xmpp.addr.Jid;

abstract class AbstractJid
implements Jid {
    AbstractJid() {
    }

    @Override
    public final boolean isFullJid() {
        return this.getResource() != null;
    }

    @Override
    public final boolean isBareJid() {
        return this.getResource() == null;
    }

    @Override
    public final boolean isDomainJid() {
        return this.getLocal() == null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jid)) {
            return false;
        }
        Jid other = (Jid)o;
        return Objects.equals(this.getLocal(), other.getLocal()) && Objects.equals(this.getDomain(), other.getDomain()) && Objects.equals(this.getResource(), other.getResource());
    }

    public final int hashCode() {
        return Objects.hash(this.getLocal(), this.getDomain(), this.getResource());
    }

    @Override
    public final int compareTo(Jid o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result;
            Collator collator = Collator.getInstance();
            if (this.getDomain() != null) {
                result = o.getDomain() != null ? collator.compare(this.getDomain(), o.getDomain()) : -1;
            } else {
                int n = result = o.getDomain() != null ? 1 : 0;
            }
            if (result == 0) {
                if (this.getLocal() != null) {
                    result = o.getLocal() != null ? collator.compare(this.getLocal(), o.getLocal()) : 1;
                } else {
                    int n = result = o.getLocal() != null ? -1 : 0;
                }
            }
            if (result == 0) {
                if (this.getResource() != null) {
                    return o.getResource() != null ? collator.compare(this.getResource(), o.getResource()) : 1;
                }
                return o.getResource() != null ? -1 : 0;
            }
            return result;
        }
        return -1;
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public final String toString() {
        return AbstractJid.toString(this.getLocal(), this.getDomain(), this.getResource());
    }

    @Override
    public final String toEscapedString() {
        return AbstractJid.toString(this.getEscapedLocal(), this.getDomain(), this.getResource());
    }

    static String toString(String local, String domain, String resource) {
        StringBuilder sb = new StringBuilder();
        if (local != null) {
            sb.append(local).append('@');
        }
        sb.append(domain);
        if (resource != null) {
            sb.append('/').append(resource);
        }
        return sb.toString();
    }
}

